/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.obs.IBitSet;
import org.apache.cassandra.utils.obs.OffHeapBitSet;
import org.apache.cassandra.utils.obs.OpenBitSet;

abstract class BloomFilterSerializer
implements ISerializer<BloomFilter> {
    BloomFilterSerializer() {
    }

    @Override
    public void serialize(BloomFilter bf, DataOutputPlus out) throws IOException {
        out.writeInt(bf.hashCount);
        bf.bitset.serialize(out);
    }

    @Override
    public BloomFilter deserialize(DataInput in) throws IOException {
        return this.deserialize(in, false);
    }

    public BloomFilter deserialize(DataInput in, boolean offheap) throws IOException {
        int hashes = in.readInt();
        IBitSet bs = offheap ? OffHeapBitSet.deserialize(in) : OpenBitSet.deserialize(in);
        return this.createFilter(hashes, bs);
    }

    protected abstract BloomFilter createFilter(int var1, IBitSet var2);

    @Override
    public long serializedSize(BloomFilter bf, TypeSizes typeSizes) {
        int size = typeSizes.sizeof(bf.hashCount);
        size = (int)((long)size + bf.bitset.serializedSize(typeSizes));
        return size;
    }
}

