/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionMulti;
import org.apache.cassandra.stress.settings.OptionSimple;

class OptionReplication
extends OptionMulti {
    private final OptionSimple strategy = new OptionSimple("strategy=", new StrategyAdapter(), "org.apache.cassandra.locator.SimpleStrategy", "The replication strategy to use", false);
    private final OptionSimple factor = new OptionSimple("factor=", "[0-9]+", "1", "The number of replicas", false);

    public OptionReplication() {
        super("replication", "Define the replication strategy and any parameters", true);
    }

    public String getStrategy() {
        return this.strategy.value();
    }

    public Map<String, String> getOptions() {
        Map<String, String> options = this.extraOptions();
        if (!options.containsKey("replication_factor") && (this.strategy.value().equals("org.apache.cassandra.locator.SimpleStrategy") || this.factor.setByUser())) {
            options.put("replication_factor", this.factor.value());
        }
        return options;
    }

    @Override
    protected List<? extends Option> options() {
        return Arrays.asList(this.strategy, this.factor);
    }

    @Override
    public boolean happy() {
        return true;
    }

    private static final class StrategyAdapter
    implements Function<String, String> {
        private StrategyAdapter() {
        }

        public String apply(String name) {
            String strategy = null;
            for (String fullname : new String[]{name, "org.apache.cassandra.locator." + name}) {
                try {
                    Class<?> clazz = Class.forName(fullname);
                    if (!AbstractReplicationStrategy.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException(clazz + " is not a replication strategy");
                    }
                    strategy = fullname;
                    break;
                }
                catch (Exception ignore) {
                }
            }
            if (strategy == null) {
                throw new IllegalArgumentException("Invalid replication strategy: " + name);
            }
            return strategy;
        }
    }
}

