/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionCompaction;
import org.apache.cassandra.stress.settings.OptionReplication;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandUser;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SettingsSchema
implements Serializable {
    public static final String DEFAULT_VALIDATOR = "BytesType";
    private final String replicationStrategy;
    private final Map<String, String> replicationStrategyOptions;
    private final String compression;
    private final String compactionStrategy;
    private final Map<String, String> compactionStrategyOptions;
    public final String keyspace;

    public SettingsSchema(Options options, SettingsCommand command) {
        this.keyspace = command instanceof SettingsCommandUser ? ((SettingsCommandUser)command).profile.keyspaceName : options.keyspace.value();
        this.replicationStrategy = options.replication.getStrategy();
        this.replicationStrategyOptions = options.replication.getOptions();
        this.compression = options.compression.value();
        this.compactionStrategy = options.compaction.getStrategy();
        this.compactionStrategyOptions = options.compaction.getOptions();
    }

    public void createKeySpaces(StressSettings settings) {
        this.createKeySpacesThrift(settings);
    }

    public void createKeySpacesThrift(StressSettings settings) {
        KsDef ksdef = new KsDef();
        CfDef standardCfDef = new CfDef(this.keyspace, "standard1");
        HashMap<String, String> compressionOptions = new HashMap<String, String>();
        if (this.compression != null) {
            compressionOptions.put("sstable_compression", this.compression);
        }
        String comparator = settings.columns.comparator;
        standardCfDef.setComparator_type(comparator).setDefault_validation_class(DEFAULT_VALIDATOR).setCompression_options(compressionOptions);
        for (int i = 0; i < settings.columns.names.size(); ++i) {
            standardCfDef.addToColumn_metadata(new ColumnDef(settings.columns.names.get(i), DEFAULT_VALIDATOR));
        }
        CfDef counterCfDef = new CfDef(this.keyspace, "counter1").setComparator_type(comparator).setDefault_validation_class("CounterColumnType").setCompression_options(compressionOptions);
        ksdef.setName(this.keyspace);
        ksdef.setStrategy_class(this.replicationStrategy);
        if (!this.replicationStrategyOptions.isEmpty()) {
            ksdef.setStrategy_options(this.replicationStrategyOptions);
        }
        if (this.compactionStrategy != null) {
            standardCfDef.setCompaction_strategy(this.compactionStrategy);
            counterCfDef.setCompaction_strategy(this.compactionStrategy);
            if (!this.compactionStrategyOptions.isEmpty()) {
                standardCfDef.setCompaction_strategy_options(this.compactionStrategyOptions);
                counterCfDef.setCompaction_strategy_options(this.compactionStrategyOptions);
            }
        }
        ksdef.setCf_defs(new ArrayList<CfDef>(Arrays.asList(standardCfDef, counterCfDef)));
        Cassandra.Client client = settings.getRawThriftClient(false);
        try {
            client.system_add_keyspace(ksdef);
            client.set_cql_version("3.0.0");
            client.set_keyspace(this.keyspace);
            client.execute_cql3_query(this.createCounterCFStatementForCQL3(settings), Compression.NONE, ConsistencyLevel.ONE);
            if (settings.mode.cqlVersion.isCql()) {
                client.set_cql_version(settings.mode.cqlVersion.connectVersion);
            }
            System.out.println(String.format("Created keyspaces. Sleeping %ss for propagation.", settings.node.nodes.size()));
            Thread.sleep((long)settings.node.nodes.size() * 1000L);
        }
        catch (InvalidRequestException e) {
            System.err.println("Unable to create stress keyspace: " + e.getWhy());
        }
        catch (Exception e) {
            System.err.println("!!!! " + e.getMessage());
        }
    }

    private ByteBuffer createCounterCFStatementForCQL3(StressSettings options) {
        StringBuilder counter3 = new StringBuilder("CREATE TABLE \"Counter3\" (KEY blob PRIMARY KEY, ");
        for (int i = 0; i < options.columns.maxColumnsPerKey; ++i) {
            counter3.append("c").append(i).append(" counter");
            if (i == options.columns.maxColumnsPerKey - 1) continue;
            counter3.append(", ");
        }
        counter3.append(");");
        return ByteBufferUtil.bytes((String)counter3.toString());
    }

    public static SettingsSchema get(Map<String, String[]> clArgs, SettingsCommand command) {
        String[] params = clArgs.remove("-schema");
        if (params == null) {
            return new SettingsSchema(new Options(), command);
        }
        if (command instanceof SettingsCommandUser) {
            throw new IllegalArgumentException("-schema can only be provided with predefined operations insert, read, etc.; the 'user' command requires a schema yaml instead");
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsSchema.printHelp();
            System.out.println("Invalid -schema options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsSchema((Options)options, command);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-schema", new Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsSchema.printHelp();
            }
        };
    }

    private static final class Options
    extends GroupedOptions {
        final OptionReplication replication = new OptionReplication();
        final OptionCompaction compaction = new OptionCompaction();
        final OptionSimple keyspace = new OptionSimple("keyspace=", ".*", "keyspace1", "The keyspace name to use", false);
        final OptionSimple compression = new OptionSimple("compression=", ".*", null, "Specify the compression to use for sstable, default:no compression", false);

        private Options() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.replication, this.keyspace, this.compaction, this.compression);
        }
    }
}

