# Apache Cassandra and Pull Requests

Apache Cassandra doesn't use GitHub pull requests as part of the development process.
In fact, this repository is a GitHub mirror of [the official repo](https://git-wip-us.apache.org/repos/asf/cassandra.git). The development team has no control over it. We cannot merge or close any pull requests opened for the apache/cassandra repository, so please don't open them.

# How to Contribute

Use [Cassandra JIRA](https://issues.apache.org/jira/browse/CASSANDRA/) to create an issue, then either attach a patch or post a link to a GitHub branch with your changes.

# Useful Links

- How you can contribute to Apache Cassandra [presentation](http://www.slideshare.net/yukim/cassandrasummit2013) by Yuki Morishita
- Code style [wiki page](https://wiki.apache.org/cassandra/CodeStyle)
- Running Cassandra in IDEA [guide](https://wiki.apache.org/cassandra/RunningCassandraInIDEA)
- Running Cassandra in Eclipse [guide](https://wiki.apache.org/cassandra/RunningCassandraInEclipse)
- Cassandra Cluster Manager - [CCM](https://github.com/pcmanus/ccm) and a guide [blog post](http://www.datastax.com/dev/blog/ccm-a-development-tool-for-creating-local-cassandra-clusters)
- Cassandra Distributed Tests aka [dtests](https://github.com/riptano/cassandra-dtest)
