/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.caffinitas.ohc.CacheLoader;
import org.caffinitas.ohc.CloseableIterator;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.OHCacheStats;
import org.caffinitas.ohc.histo.EstimatedHistogram;

public interface OHCache<K, V>
extends Closeable {
    public void put(K var1, V var2);

    public boolean addOrReplace(K var1, V var2, V var3);

    public boolean putIfAbsent(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void remove(K var1);

    public void removeAll(Iterable<K> var1);

    public void clear();

    public V get(K var1);

    public boolean containsKey(K var1);

    public DirectValueAccess getDirect(K var1);

    public Future<V> getWithLoaderAsync(K var1, CacheLoader<K, V> var2);

    public V getWithLoader(K var1, CacheLoader<K, V> var2) throws InterruptedException, ExecutionException;

    public V getWithLoader(K var1, CacheLoader<K, V> var2, long var3, TimeUnit var5) throws InterruptedException, ExecutionException, TimeoutException;

    public CloseableIterator<K> hotKeyIterator(int var1);

    public CloseableIterator<K> keyIterator();

    public CloseableIterator<ByteBuffer> hotKeyBufferIterator(int var1);

    public CloseableIterator<ByteBuffer> keyBufferIterator();

    public boolean deserializeEntry(ReadableByteChannel var1) throws IOException;

    public boolean serializeEntry(K var1, WritableByteChannel var2) throws IOException;

    public int deserializeEntries(ReadableByteChannel var1) throws IOException;

    public int serializeHotNEntries(int var1, WritableByteChannel var2) throws IOException;

    public int serializeHotNKeys(int var1, WritableByteChannel var2) throws IOException;

    public CloseableIterator<K> deserializeKeys(ReadableByteChannel var1) throws IOException;

    public void resetStatistics();

    public long size();

    public int[] hashTableSizes();

    public long[] perSegmentSizes();

    public EstimatedHistogram getBucketHistogram();

    public int segments();

    public long capacity();

    public long memUsed();

    public long freeCapacity();

    public float loadFactor();

    public OHCacheStats stats();

    public void setCapacity(long var1);
}

