/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphExecutionInfoConverter;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public interface GraphResultSet
extends Iterable<GraphNode> {
    @Nullable
    default public GraphNode one() {
        Iterator graphNodeIterator = this.iterator();
        return graphNodeIterator.hasNext() ? (GraphNode)graphNodeIterator.next() : null;
    }

    @NonNull
    default public List<GraphNode> all() {
        if (!this.iterator().hasNext()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Iterable)this);
    }

    public void cancel();

    @NonNull
    default public ExecutionInfo getRequestExecutionInfo() {
        return GraphExecutionInfoConverter.convert(this.getExecutionInfo());
    }

    @Deprecated
    @NonNull
    public GraphExecutionInfo getExecutionInfo();
}

