/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Arrays;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.merge.MergeCase;
import org.apache.cayenne.dbsync.merge.context.EntityMergeSupport;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Relationship;
import org.junit.Assert;
import org.junit.Test;

public class EntityMergeSupportIT
extends MergeCase {
    @Test
    public void testMerging() {
        DbEntity dbEntity1 = new DbEntity("NEW_TABLE");
        DbAttribute e1col1 = new DbAttribute("ID", 4, dbEntity1);
        e1col1.setMandatory(true);
        e1col1.setPrimaryKey(true);
        dbEntity1.addAttribute(e1col1);
        DbAttribute e1col2 = new DbAttribute("NAME", 12, dbEntity1);
        e1col2.setMaxLength(10);
        e1col2.setMandatory(false);
        dbEntity1.addAttribute(e1col2);
        this.map.addDbEntity(dbEntity1);
        DbEntity dbEntity2 = new DbEntity("NEW_TABLE2");
        DbAttribute e2col1 = new DbAttribute("ID", 4, dbEntity2);
        e2col1.setMandatory(true);
        e2col1.setPrimaryKey(true);
        dbEntity2.addAttribute(e2col1);
        DbAttribute e2col2 = new DbAttribute("FK", 4, dbEntity2);
        dbEntity2.addAttribute(e2col2);
        this.map.addDbEntity(dbEntity2);
        DbRelationship rel1To2 = new DbRelationship("rel1To2");
        rel1To2.setSourceEntity((Entity)dbEntity1);
        rel1To2.setTargetEntityName((Entity)dbEntity2);
        rel1To2.setToMany(true);
        rel1To2.addJoin(new DbJoin(rel1To2, e1col1.getName(), e2col2.getName()));
        dbEntity1.addRelationship((Relationship)rel1To2);
        DbRelationship rel2To1 = new DbRelationship("rel2To1");
        rel2To1.setSourceEntity((Entity)dbEntity2);
        rel2To1.setTargetEntityName((Entity)dbEntity1);
        rel2To1.setToMany(false);
        rel2To1.addJoin(new DbJoin(rel2To1, e2col2.getName(), e1col1.getName()));
        dbEntity2.addRelationship((Relationship)rel2To1);
        Assert.assertSame((Object)rel1To2, (Object)rel2To1.getReverseRelationship());
        Assert.assertSame((Object)rel2To1, (Object)rel1To2.getReverseRelationship());
        ObjEntity objEntity1 = new ObjEntity("NewTable");
        objEntity1.setDbEntity(dbEntity1);
        this.map.addObjEntity(objEntity1);
        ObjEntity objEntity2 = new ObjEntity("NewTable2");
        objEntity2.setDbEntity(dbEntity2);
        this.map.addObjEntity(objEntity2);
        EntityMergeSupport entityMergeSupport = new EntityMergeSupport(new DefaultObjectNameGenerator(NoStemStemmer.getInstance()), NamePatternMatcher.EXCLUDE_ALL, true, true, false);
        Assert.assertTrue((boolean)entityMergeSupport.synchronizeWithDbEntities(Arrays.asList(objEntity1, objEntity2)));
        Assert.assertNotNull((Object)objEntity1.getAttribute("name"));
        Assert.assertNotNull((Object)objEntity1.getRelationship("newTable2s"));
        Assert.assertNotNull((Object)objEntity2.getRelationship("newTable"));
        Assert.assertEquals((long)objEntity1.getRelationship("newTable2s").getDeleteRule(), (long)3L);
        Assert.assertEquals((long)objEntity2.getRelationship("newTable").getDeleteRule(), (long)1L);
        this.map.removeObjEntity(objEntity2.getName());
        this.map.removeObjEntity(objEntity1.getName());
        this.map.removeDbEntity(dbEntity2.getName());
        this.map.removeDbEntity(dbEntity1.getName());
    }
}

