/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.builders;

import org.apache.cayenne.dbsync.merge.builders.DefaultBuilder;
import org.apache.cayenne.dbsync.merge.builders.ObjAttributeBuilder;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.commons.lang.StringUtils;

public class ObjEntityBuilder
extends DefaultBuilder<ObjEntity> {
    public ObjEntityBuilder() {
        super(new ObjEntity());
    }

    public ObjEntityBuilder name() {
        return this.name(this.getRandomJavaName());
    }

    public ObjEntityBuilder name(String name) {
        ((ObjEntity)this.obj).setName(name);
        return this;
    }

    public ObjEntityBuilder attributes(ObjAttribute ... attributes) {
        for (ObjAttribute attribute : attributes) {
            ((ObjEntity)this.obj).addAttribute((Attribute)attribute);
        }
        return this;
    }

    public ObjEntityBuilder attributes(ObjAttributeBuilder ... attributes) {
        for (ObjAttributeBuilder attribute : attributes) {
            ((ObjEntity)this.obj).addAttribute((Attribute)attribute.build());
        }
        return this;
    }

    public ObjEntityBuilder attributes(int numberUpTo) {
        for (int i = 0; i < numberUpTo; ++i) {
            ((ObjEntity)this.obj).addAttribute((Attribute)new ObjAttributeBuilder().random());
        }
        return this;
    }

    @Override
    public ObjEntity build() {
        if (((ObjEntity)this.obj).getName() == null) {
            ((ObjEntity)this.obj).setName(StringUtils.capitalize((String)this.getRandomJavaName()));
        }
        return (ObjEntity)this.obj;
    }

    @Override
    public ObjEntity random() {
        if (this.dataFactory.chance(99)) {
            this.attributes(this.dataFactory.getNumberUpTo(20));
        }
        return this.build();
    }

    public ObjEntityBuilder clazz(String s) {
        ((ObjEntity)this.obj).setClassName(s);
        return this;
    }

    public ObjEntityBuilder dbEntity(String table) {
        ((ObjEntity)this.obj).setDbEntityName(table);
        return this;
    }
}

