/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.List;
import org.apache.cayenne.dbsync.merge.MergeCase;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.SetGeneratedFlagToDb;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SetGeneratedFlagToDbIT
extends MergeCase {
    @Inject
    UnitDbAdapter dbAdapter;

    @Test
    public void setGeneratedFlag() throws Exception {
        DbEntity dbEntity = this.createTestTable(false);
        Assert.assertNotNull((Object)dbEntity);
        DbAttribute attribute = dbEntity.getAttribute("ID");
        Assert.assertNotNull((Object)attribute);
        Assert.assertFalse((boolean)attribute.isGenerated());
        attribute.setGenerated(true);
        List<MergerToken> tokens = this.createMergeTokens();
        if (!this.dbAdapter.supportsGeneratedKeys()) {
            Assert.assertEquals((long)0L, (long)tokens.size());
            return;
        }
        Assert.assertEquals((long)1L, (long)tokens.size());
        MergerToken token = tokens.get(0);
        Assert.assertTrue((boolean)(token instanceof SetGeneratedFlagToDb));
        try {
            this.execute(token);
            if (!this.dbAdapter.supportsGeneratedKeysAdd()) {
                Assert.fail((String)"SetGeneratedFlagToDb should fail on current DB");
            }
        }
        catch (UnsupportedOperationException ignored) {
            return;
        }
        this.assertTokensAndExecute(0, 0);
    }

    @Test
    public void dropGeneratedFlag() throws Exception {
        DbEntity dbEntity = this.createTestTable(true);
        Assert.assertNotNull((Object)dbEntity);
        DbAttribute attribute = dbEntity.getAttribute("ID");
        Assert.assertNotNull((Object)attribute);
        Assert.assertTrue((boolean)attribute.isGenerated());
        attribute.setGenerated(false);
        List<MergerToken> tokens = this.createMergeTokens();
        if (!this.dbAdapter.supportsGeneratedKeys()) {
            Assert.assertEquals((long)0L, (long)tokens.size());
            return;
        }
        Assert.assertEquals((long)1L, (long)tokens.size());
        MergerToken token = tokens.get(0);
        Assert.assertTrue((boolean)(token instanceof SetGeneratedFlagToDb));
        try {
            this.execute(token);
            if (!this.dbAdapter.supportsGeneratedKeysDrop()) {
                Assert.fail((String)"SetGeneratedFlagToDb should fail on current DB");
            }
        }
        catch (UnsupportedOperationException ignored) {
            return;
        }
        this.assertTokensAndExecute(0, 0);
    }

    private DbEntity createTestTable(boolean generated) throws Exception {
        this.dropTestTables();
        DbEntity withGenKey = new DbEntity("NEW_TABLE");
        DbAttribute attribute = new DbAttribute("ID", 4, withGenKey);
        attribute.setMandatory(true);
        attribute.setPrimaryKey(true);
        attribute.setGenerated(generated);
        withGenKey.addAttribute(attribute);
        this.map.addDbEntity(withGenKey);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        return withGenKey;
    }

    @After
    public void dropTestTables() throws Exception {
        if (this.map.getDbEntity("NEW_TABLE") != null) {
            this.map.removeDbEntity("NEW_TABLE");
        }
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
    }
}

