/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.configuration;

import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class DriverDataSourceFactory
implements DataSourceFactory {
    private AdhocObjectFactory objectFactory;

    public DriverDataSourceFactory(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSourceInfo properties = nodeDescriptor.getDataSourceDescriptor();
        if (properties == null) {
            throw new IllegalArgumentException("'nodeDescriptor' contains no datasource descriptor");
        }
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, properties.getJdbcDriver());
        return new DriverDataSource(driver, properties.getDataSourceUrl(), properties.getUserName(), properties.getPassword());
    }
}

