/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.Connection;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DbLoaderIT
extends ServerCase {
    private static final DbLoaderConfiguration CONFIG = new DbLoaderConfiguration();
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DbAdapter adapter;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    private Connection connection;

    @Test
    public void testSimpleLoad() throws Exception {
        DbLoader loader = this.createDbLoader(true, true);
        DataMap loaded = loader.load();
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals((Object)"__generated_by_dbloader__", (Object)loaded.getName());
        DbEntity artist = loaded.getDbEntity("ARTIST");
        Assert.assertNotNull((Object)artist);
        DbAttribute id = this.getDbAttribute(artist, "ARTIST_ID");
        Assert.assertNotNull((Object)id);
        Assert.assertTrue((boolean)id.isMandatory());
        Assert.assertTrue((boolean)id.isPrimaryKey());
        DbAttribute name = this.getDbAttribute(artist, "ARTIST_NAME");
        Assert.assertNotNull((Object)name);
        Assert.assertTrue((boolean)name.isMandatory());
        DbAttribute date = this.getDbAttribute(artist, "DATE_OF_BIRTH");
        Assert.assertNotNull((Object)date);
        Assert.assertFalse((boolean)date.isMandatory());
        Assert.assertEquals((long)4L, (long)artist.getRelationships().size());
        DbRelationship exhibits = artist.getRelationship("artistExhibits");
        Assert.assertNotNull((Object)exhibits);
        Assert.assertEquals((Object)"ARTIST_EXHIBIT", (Object)exhibits.getTargetEntityName().toUpperCase());
        DbEntity target = exhibits.getTargetEntity();
        Assert.assertNotNull((Object)target);
    }

    private DbAttribute getDbAttribute(DbEntity ent, String name) {
        DbAttribute da = ent.getAttribute(name);
        if (da == null) {
            da = ent.getAttribute(name.toLowerCase());
        }
        return da;
    }

    @Before
    public void before() throws Exception {
        this.connection = this.dataSourceFactory.getSharedDataSource().getConnection();
    }

    private DbLoader createDbLoader(boolean meaningfulPK, boolean meaningfulFK) {
        return new DbLoader(this.adapter, this.connection, CONFIG, null, new DefaultObjectNameGenerator(NoStemStemmer.getInstance()));
    }

    @After
    public void after() throws Exception {
        this.connection.close();
    }
}

