/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.merge.DataMapMerger;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.dbsync.merge.token.db.SetColumnTypeToDb;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.LoggingDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.dbsync.unit.DbSyncCase;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseServerRuntime(value="cayenne-testmap.xml")
public abstract class MergeCase
extends DbSyncCase {
    @Inject
    protected EntityResolver resolver;
    @Inject
    protected DataNode node;
    protected DataMap map;
    private Logger logger = LoggerFactory.getLogger(MergeCase.class);
    @Inject
    private DBHelper dbHelper;
    @Inject
    private ServerRuntime runtime;
    @Inject
    protected UnitDbAdapter accessStackAdapter;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;

    @Override
    public void cleanUpDB() throws Exception {
        this.dbHelper.update("ARTGROUP").set("PARENT_GROUP_ID", null, 4).execute();
        super.cleanUpDB();
    }

    @Before
    public void setUp() throws Exception {
        this.map = this.runtime.getDataDomain().getDataMap("testmap");
        this.filterDataMap();
        List<MergerToken> tokens = this.createMergeTokens();
        this.execute(tokens);
        this.assertTokensAndExecute(0, 0);
    }

    protected DataMapMerger.Builder merger() {
        return DataMapMerger.builder(this.mergerFactory());
    }

    protected List<MergerToken> createMergeTokens() {
        return this.createMergeTokens("ARTIST|GALLERY|PAINTING|NEW_TABLE2?");
    }

    protected List<MergerToken> createMergeTokens(String tableFilterInclude) {
        DataMap dbImport;
        FiltersConfig filters = FiltersConfig.create(null, null, TableFilter.include(tableFilterInclude), PatternFilter.INCLUDE_NOTHING);
        DbLoaderConfiguration loaderConfiguration = new DbLoaderConfiguration();
        loaderConfiguration.setFiltersConfig(filters);
        try (Connection conn = this.node.getDataSource().getConnection();){
            dbImport = new DbLoader(this.node.getAdapter(), conn, loaderConfiguration, new LoggingDbLoaderDelegate(LoggerFactory.getLogger(DbLoader.class)), new DefaultObjectNameGenerator(NoStemStemmer.getInstance())).load();
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Can't doLoad dataMap from db.", (Throwable)e, new Object[0]);
        }
        List<MergerToken> tokens = this.merger().filters(filters).build().createMergeTokens(this.map, dbImport);
        return this.filter(tokens);
    }

    private List<MergerToken> filter(List<MergerToken> tokens) {
        return this.filterEmptyTypeChange(this.filterEmpty(tokens));
    }

    private List<MergerToken> filterEmptyTypeChange(List<MergerToken> tokens) {
        ArrayList<MergerToken> tokensOut = new ArrayList<MergerToken>();
        for (MergerToken token : tokens) {
            if (!(token instanceof SetColumnTypeToDb)) {
                tokensOut.add(token);
                continue;
            }
            SetColumnTypeToDb setColumnToDb = (SetColumnTypeToDb)token;
            int toType = setColumnToDb.getColumnNew().getType();
            int fromType = setColumnToDb.getColumnOriginal().getType();
            if (this.accessStackAdapter.onlyGenericDateType() && MergeCase.isDateTimeType(toType) && MergeCase.isDateTimeType(fromType) || this.accessStackAdapter.onlyGenericNumberType() && TypesMapping.isNumeric((int)toType) && TypesMapping.isNumeric((int)fromType)) continue;
            tokensOut.add(token);
        }
        return tokensOut;
    }

    private static boolean isDateTimeType(int type) {
        return type == 91 || type == 92 || type == 93;
    }

    private List<MergerToken> filterEmpty(List<MergerToken> tokens) {
        ArrayList<MergerToken> tokensOut = new ArrayList<MergerToken>();
        for (MergerToken token : tokens) {
            if (token.isEmpty()) continue;
            tokensOut.add(token);
        }
        return tokensOut;
    }

    private void filterDataMap() {
        boolean excludeBinPK = this.accessStackAdapter.supportsBinaryPK();
        if (!excludeBinPK) {
            return;
        }
        ArrayList<DbEntity> entitiesToRemove = new ArrayList<DbEntity>();
        block0: for (DbEntity ent : this.map.getDbEntities()) {
            for (DbAttribute attr : ent.getAttributes()) {
                if (attr.getType() != -2 && attr.getType() != -3 && attr.getType() != -4 || !attr.isPrimaryKey() && !attr.isForeignKey()) continue;
                entitiesToRemove.add(ent);
                continue block0;
            }
        }
        for (DbEntity e : entitiesToRemove) {
            this.map.removeDbEntity(e.getName(), true);
        }
    }

    protected void execute(List<MergerToken> tokens) {
        MergerContext mergerContext = MergerContext.builder(this.map).dataNode(this.node).build();
        for (MergerToken tok : tokens) {
            tok.execute(mergerContext);
        }
    }

    protected void execute(MergerToken token) throws Exception {
        MergerContext mergerContext = MergerContext.builder(this.map).dataNode(this.node).build();
        token.execute(mergerContext);
    }

    private void executeSql(String sql) throws Exception {
        try (Connection conn = this.dataSourceFactory.getSharedDataSource().getConnection();
             Statement st = conn.createStatement();){
            st.execute(sql);
        }
    }

    protected void assertTokens(List<MergerToken> tokens, int expectedToDb, int expectedToModel) {
        int actualToDb = 0;
        int actualToModel = 0;
        for (MergerToken token : tokens) {
            if (token.getDirection().isToDb()) {
                ++actualToDb;
                continue;
            }
            if (!token.getDirection().isToModel()) continue;
            ++actualToModel;
        }
        Assert.assertEquals((String)"tokens to db", (long)expectedToDb, (long)actualToDb);
        Assert.assertEquals((String)"tokens to model", (long)expectedToModel, (long)actualToModel);
    }

    protected void assertTokensAndExecute(int expectedToDb, int expectedToModel) {
        List<MergerToken> tokens = this.createMergeTokens();
        this.assertTokens(tokens, expectedToDb, expectedToModel);
        this.execute(tokens);
    }

    protected MergerTokenFactory mergerFactory() {
        return (MergerTokenFactory)((MergerTokenFactoryProvider)((Object)this.runtime.getInjector().getInstance(MergerTokenFactoryProvider.class))).get(this.node.getAdapter());
    }

    protected void dropTableIfPresent(String tableName) throws Exception {
        DataMap map = new DataMap("dummy");
        map.setQuotingSQLIdentifiers(map.isQuotingSQLIdentifiers());
        DbEntity entity = new DbEntity(tableName);
        map.addDbEntity(entity);
        AbstractToDbToken t = (AbstractToDbToken)this.mergerFactory().createDropTableToDb(entity);
        for (String sql : t.createSql(this.node.getAdapter())) {
            try {
                this.executeSql(sql);
            }
            catch (Exception e) {
                this.logger.info("Exception dropping table " + tableName + ", probably abscent..");
            }
        }
    }
}

