/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AddColumnToDb;
import org.apache.cayenne.dbsync.merge.token.db.AddRelationshipToDb;
import org.apache.cayenne.dbsync.merge.token.db.CreateTableToDb;
import org.apache.cayenne.dbsync.merge.token.db.DropColumnToDb;
import org.apache.cayenne.dbsync.merge.token.db.DropRelationshipToDb;
import org.apache.cayenne.dbsync.merge.token.db.DropTableToDb;
import org.apache.cayenne.dbsync.merge.token.model.AddColumnToModel;
import org.apache.cayenne.dbsync.merge.token.model.AddRelationshipToModel;
import org.apache.cayenne.dbsync.merge.token.model.CreateTableToModel;
import org.apache.cayenne.dbsync.merge.token.model.DropColumnToModel;
import org.apache.cayenne.dbsync.merge.token.model.DropRelationshipToModel;
import org.apache.cayenne.dbsync.merge.token.model.DropTableToModel;
import org.junit.Assert;
import org.junit.Test;

public class TokenSortTest {
    private List<String> toClassesNames(List<MergerToken> sort) {
        ArrayList<String> res = new ArrayList<String>(sort.size());
        for (MergerToken mergerToken : sort) {
            res.add(mergerToken.getClass().getSimpleName());
        }
        return res;
    }

    @Test
    public void testSortStability() throws Exception {
        List<MergerToken> tokens = Arrays.asList(new AddRelationshipToModel(null, null), new AddColumnToModel(null, null), new AddColumnToDb(null, null), new CreateTableToModel(null), new DropTableToModel(null), new DropColumnToModel(null, null), new DropRelationshipToModel(null, null));
        Collections.sort(tokens);
        List<String> actual = this.toClassesNames(tokens);
        List<String> expected = Arrays.asList("DropRelationshipToModel", "DropColumnToModel", "DropTableToModel", "CreateTableToModel", "AddColumnToDb", "AddColumnToModel", "AddRelationshipToModel");
        Assert.assertEquals(expected, actual);
        Collections.sort(tokens);
        actual = this.toClassesNames(tokens);
        Assert.assertEquals(expected, actual);
        List<MergerToken> tokens2 = Arrays.asList(new AddColumnToModel(null, null), new AddRelationshipToModel(null, null), new CreateTableToModel(null), new AddColumnToDb(null, null), new DropColumnToModel(null, null), new DropRelationshipToModel(null, null), new DropTableToModel(null));
        Collections.sort(tokens2);
        actual = this.toClassesNames(tokens);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testToModelTokensCompare() throws Exception {
        List<MergerToken> tokens = Arrays.asList(new DropColumnToModel(null, null), new DropRelationshipToModel(null, null), new DropTableToModel(null), new AddColumnToDb(null, null), new AddRelationshipToModel(null, null), new AddColumnToModel(null, null), new CreateTableToModel(null));
        Collections.sort(tokens);
        List<String> actual = this.toClassesNames(tokens);
        List<String> expected = Arrays.asList("DropRelationshipToModel", "DropColumnToModel", "DropTableToModel", "CreateTableToModel", "AddColumnToDb", "AddColumnToModel", "AddRelationshipToModel");
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testToDbTokensCompare() throws Exception {
        List<MergerToken> tokens = Arrays.asList(new DropColumnToDb(null, null), new DropRelationshipToDb(null, null), new DropTableToDb(null), new AddColumnToModel(null, null), new AddRelationshipToDb(null, null), new AddColumnToDb(null, null), new CreateTableToDb(null));
        Collections.sort(tokens);
        List<String> actual = this.toClassesNames(tokens);
        List<String> expected = Arrays.asList("DropRelationshipToDb", "DropColumnToDb", "DropTableToDb", "CreateTableToDb", "AddColumnToDb", "AddColumnToModel", "AddRelationshipToDb");
        Assert.assertEquals(expected, actual);
    }
}

