/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.reverse.dbimport.AntNestedElement;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeRelationship;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.util.Util;

public abstract class FilterContainer {
    private String name;
    private final Collection<IncludeTable> includeTableCollection = new LinkedList<IncludeTable>();
    private final Collection<ExcludeTable> excludeTableCollection = new LinkedList<ExcludeTable>();
    private final Collection<IncludeColumn> includeColumnCollection = new LinkedList<IncludeColumn>();
    private final Collection<ExcludeColumn> excludeColumnCollection = new LinkedList<ExcludeColumn>();
    private final Collection<IncludeProcedure> includeProcedureCollection = new LinkedList<IncludeProcedure>();
    private final Collection<ExcludeProcedure> excludeProcedureCollection = new LinkedList<ExcludeProcedure>();
    private final Collection<ExcludeRelationship> excludeRelationshipCollection = new LinkedList<ExcludeRelationship>();

    public FilterContainer() {
    }

    public FilterContainer(FilterContainer original) {
        this.setName(original.getName());
        for (IncludeTable includeTable : original.getIncludeTables()) {
            this.addIncludeTable(new IncludeTable(includeTable));
        }
        for (ExcludeTable excludeTable : original.getExcludeTables()) {
            this.addExcludeTable(new ExcludeTable(excludeTable));
        }
        for (IncludeColumn includeColumn : original.getIncludeColumns()) {
            this.addIncludeColumn(new IncludeColumn(includeColumn));
        }
        for (ExcludeColumn excludeColumn : original.getExcludeColumns()) {
            this.addExcludeColumn(new ExcludeColumn(excludeColumn));
        }
        for (IncludeProcedure includeProcedure : original.getIncludeProcedures()) {
            this.addIncludeProcedure(new IncludeProcedure(includeProcedure));
        }
        for (ExcludeProcedure excludeProcedure : original.getExcludeProcedures()) {
            this.addExcludeProcedure(new ExcludeProcedure(excludeProcedure));
        }
    }

    public Collection<IncludeTable> getIncludeTables() {
        return this.includeTableCollection;
    }

    public Collection<ExcludeTable> getExcludeTables() {
        return this.excludeTableCollection;
    }

    public Collection<IncludeColumn> getIncludeColumns() {
        return this.includeColumnCollection;
    }

    public Collection<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumnCollection;
    }

    public Collection<IncludeProcedure> getIncludeProcedures() {
        return this.includeProcedureCollection;
    }

    public Collection<ExcludeProcedure> getExcludeProcedures() {
        return this.excludeProcedureCollection;
    }

    public Collection<ExcludeRelationship> getExcludeRelationship() {
        return this.excludeRelationshipCollection;
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumnCollection.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumnCollection.add(excludeColumn);
    }

    public void addIncludeTable(IncludeTable includeTable) {
        this.includeTableCollection.add(includeTable);
    }

    public void addExcludeTable(ExcludeTable excludeTable) {
        this.excludeTableCollection.add(excludeTable);
    }

    public void addIncludeProcedure(IncludeProcedure includeProcedure) {
        this.includeProcedureCollection.add(includeProcedure);
    }

    public void addExcludeProcedure(ExcludeProcedure excludeProcedure) {
        this.excludeProcedureCollection.add(excludeProcedure);
    }

    public void addExcludeRelationship(ExcludeRelationship excludeRelationship) {
        this.excludeRelationshipCollection.add(excludeRelationship);
    }

    public void clearIncludeTables() {
        this.includeTableCollection.clear();
    }

    public void clearExcludeTables() {
        this.excludeTableCollection.clear();
    }

    public void clearIncludeProcedures() {
        this.includeProcedureCollection.clear();
    }

    public void clearExcludeProcedures() {
        this.excludeProcedureCollection.clear();
    }

    public void clearIncludeColumns() {
        this.includeColumnCollection.clear();
    }

    public void clearExcludeColumns() {
        this.excludeColumnCollection.clear();
    }

    public void clearExcludeRelationships() {
        this.excludeRelationshipCollection.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void set(String name) {
        this.setName(name);
    }

    public void addConfiguredName(AntNestedElement name) {
        this.setName(name.getName());
    }

    public void addText(String name) {
        if (Util.isBlank((CharSequence)name)) {
            return;
        }
        this.setName(name);
    }

    public boolean isEmptyContainer() {
        return this.includeColumnCollection.isEmpty() && this.excludeColumnCollection.isEmpty() && this.includeTableCollection.isEmpty() && this.excludeTableCollection.isEmpty() && this.includeProcedureCollection.isEmpty() && this.excludeProcedureCollection.isEmpty() && this.excludeRelationshipCollection.isEmpty();
    }

    static boolean isBlank(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder res, String prefix) {
        this.appendCollection(res, prefix, this.includeTableCollection);
        this.appendCollection(res, prefix, this.excludeTableCollection);
        this.appendCollection(res, prefix, this.includeColumnCollection);
        this.appendCollection(res, prefix, this.excludeColumnCollection);
        this.appendCollection(res, prefix, this.includeProcedureCollection);
        this.appendCollection(res, prefix, this.excludeProcedureCollection);
        this.appendCollection(res, prefix, this.excludeRelationshipCollection);
        return res;
    }

    protected void appendCollection(StringBuilder res, String prefix, Collection<? extends PatternParam> collection) {
        if (!FilterContainer.isBlank(collection)) {
            for (PatternParam patternParam : collection) {
                patternParam.toString(res, prefix);
            }
        }
    }
}

