/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import junit.framework.TestCase;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;

public class PatternFilterTest
extends TestCase {
    public void testInclude() throws Exception {
        PatternFilter filter = new PatternFilter().include("aaa").include("bbb");
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("aaa"));
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("bbb"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("aaaa"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("aa"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("abb"));
        filter = new PatternFilter().include("^v_.*$");
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("v_new_view"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("new_view"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("view"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("girl"));
    }

    public void testExclude() throws Exception {
        PatternFilter filter = new PatternFilter().exclude("aaa").exclude("bbb");
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("aaa"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("bbb"));
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("aaaa"));
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("aa"));
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("abb"));
    }

    public void testIncludeExclude() throws Exception {
        PatternFilter filter = new PatternFilter().include("aa.*").exclude("aaa");
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("aaa"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("bbb"));
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("aaaa"));
        PatternFilterTest.assertTrue((boolean)filter.isIncluded("aa"));
        PatternFilterTest.assertFalse((boolean)filter.isIncluded("abb"));
    }

    public void testIncludeAllFilter() {
        PatternFilterTest.assertTrue((boolean)PatternFilter.INCLUDE_EVERYTHING.isIncluded("qwe"));
        PatternFilterTest.assertTrue((boolean)PatternFilter.INCLUDE_EVERYTHING.isIncluded(""));
        PatternFilterTest.assertTrue((boolean)PatternFilter.INCLUDE_EVERYTHING.isIncluded(null));
    }

    public void testIncludeNoneFilter() {
        PatternFilterTest.assertFalse((boolean)PatternFilter.INCLUDE_NOTHING.isIncluded("qwe"));
        PatternFilterTest.assertFalse((boolean)PatternFilter.INCLUDE_NOTHING.isIncluded(""));
        PatternFilterTest.assertFalse((boolean)PatternFilter.INCLUDE_NOTHING.isIncluded(null));
    }
}

