/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.lifecycle.cache.CacheGroups;
import org.apache.cayenne.lifecycle.cache.InvalidationFunction;
import org.apache.cayenne.lifecycle.cache.InvalidationHandler;

public class CacheGroupsHandler
implements InvalidationHandler {
    @Override
    public InvalidationFunction canHandle(Class<? extends Persistent> type) {
        CacheGroups a = type.getAnnotation(CacheGroups.class);
        if (a == null) {
            return null;
        }
        String[] groups = a.value();
        if (groups.length == 0) {
            return null;
        }
        final List<String> groupsList = Arrays.asList(groups);
        return new InvalidationFunction(){

            @Override
            public Collection<String> apply(Persistent persistent) {
                return groupsList;
            }
        };
    }
}

