/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.cache;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.lifecycle.cache.CacheGroupsHandler;
import org.apache.cayenne.lifecycle.cache.CacheInvalidationFilter;
import org.apache.cayenne.lifecycle.cache.InvalidationHandler;
import org.apache.cayenne.tx.TransactionFilter;

public class CacheInvalidationModuleBuilder {
    public static final String INVALIDATION_HANDLERS_LIST = "cayenne.querycache.invalidation_handlers";
    private Collection<Class<? extends InvalidationHandler>> handlerTypes = new HashSet<Class<? extends InvalidationHandler>>();
    private Collection<InvalidationHandler> handlerInstances = new HashSet<InvalidationHandler>();

    public static CacheInvalidationModuleBuilder builder() {
        return new CacheInvalidationModuleBuilder();
    }

    private static ListBuilder<InvalidationHandler> contributeInvalidationHandler(Binder binder) {
        return binder.bindList(INVALIDATION_HANDLERS_LIST);
    }

    CacheInvalidationModuleBuilder() {
    }

    public CacheInvalidationModuleBuilder invalidationHandler(Class<? extends InvalidationHandler> handlerType) {
        this.handlerTypes.add(handlerType);
        return this;
    }

    public CacheInvalidationModuleBuilder invalidationHandler(InvalidationHandler handlerInstance) {
        this.handlerInstances.add(handlerInstance);
        return this;
    }

    public Module build() {
        return new Module(){

            public void configure(Binder binder) {
                ListBuilder handlers = CacheInvalidationModuleBuilder.contributeInvalidationHandler(binder);
                handlers.add(CacheGroupsHandler.class);
                handlers.addAll(CacheInvalidationModuleBuilder.this.handlerInstances);
                for (Class handlerType : CacheInvalidationModuleBuilder.this.handlerTypes) {
                    handlers.add(handlerType);
                }
                binder.bindList("cayenne.server.domain_filters").add(CacheInvalidationFilter.class).before(TransactionFilter.class);
            }
        };
    }
}

