/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.changemap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.lifecycle.changemap.ChangeMap;
import org.apache.cayenne.lifecycle.changemap.MutableObjectChange;
import org.apache.cayenne.lifecycle.changemap.ObjectChange;
import org.apache.cayenne.lifecycle.changemap.ObjectChangeType;

public class MutableChangeMap
implements ChangeMap {
    private Map<ObjectId, MutableObjectChange> changes;

    public MutableObjectChange getOrCreate(ObjectId id, ObjectChangeType type) {
        MutableObjectChange changeSet = this.getOrCreate(id);
        changeSet.setType(type);
        return changeSet;
    }

    private MutableObjectChange getOrCreate(ObjectId id) {
        MutableObjectChange objectChange;
        MutableObjectChange mutableObjectChange = objectChange = this.changes != null ? this.changes.get(id) : null;
        if (objectChange == null) {
            if (this.changes == null) {
                this.changes = new HashMap<ObjectId, MutableObjectChange>();
            }
            objectChange = new MutableObjectChange(id);
            this.changes.put(id, objectChange);
        }
        return objectChange;
    }

    public MutableObjectChange aliasId(ObjectId preCommitId, ObjectId postCommitId) {
        MutableObjectChange changeSet = this.getOrCreate(preCommitId);
        changeSet.setPostCommitId(postCommitId);
        this.changes.put(postCommitId, changeSet);
        return changeSet;
    }

    @Override
    public Collection<? extends ObjectChange> getUniqueChanges() {
        return this.changes == null ? Collections.emptySet() : new HashSet<MutableObjectChange>(this.changes.values());
    }

    @Override
    public Map<ObjectId, ? extends ObjectChange> getChanges() {
        return this.changes == null ? Collections.emptyMap() : this.changes;
    }
}

