/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.changemap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.lifecycle.changemap.AttributeChange;
import org.apache.cayenne.lifecycle.changemap.MutableAttributeChange;
import org.apache.cayenne.lifecycle.changemap.MutableToManyRelationshipChange;
import org.apache.cayenne.lifecycle.changemap.MutableToOneRelationshipChange;
import org.apache.cayenne.lifecycle.changemap.ObjectChange;
import org.apache.cayenne.lifecycle.changemap.ObjectChangeType;
import org.apache.cayenne.lifecycle.changemap.PropertyChange;
import org.apache.cayenne.lifecycle.changemap.ToManyRelationshipChange;
import org.apache.cayenne.lifecycle.changemap.ToOneRelationshipChange;

public class MutableObjectChange
implements ObjectChange {
    private static final int[] TYPE_PRECEDENCE = new int[ObjectChangeType.values().length];
    private ObjectId preCommitId;
    private ObjectId postCommitId;
    private Map<String, MutableAttributeChange> attributeChanges;
    private Map<String, MutableToManyRelationshipChange> toManyRelationshipChanges;
    private Map<String, MutableToOneRelationshipChange> toOneRelationshipChanges;
    private ObjectChangeType type;

    public MutableObjectChange(ObjectId preCommitId) {
        this.preCommitId = preCommitId;
    }

    @Override
    public Map<String, ? extends PropertyChange> getChanges() {
        HashMap<String, PropertyChange> allChanges = new HashMap<String, PropertyChange>();
        if (this.attributeChanges != null) {
            allChanges.putAll(this.attributeChanges);
        }
        if (this.toOneRelationshipChanges != null) {
            allChanges.putAll(this.toOneRelationshipChanges);
        }
        if (this.toManyRelationshipChanges != null) {
            allChanges.putAll(this.toManyRelationshipChanges);
        }
        return allChanges;
    }

    @Override
    public Map<String, ? extends AttributeChange> getAttributeChanges() {
        return this.attributeChanges != null ? this.attributeChanges : Collections.emptyMap();
    }

    @Override
    public Map<String, ? extends ToManyRelationshipChange> getToManyRelationshipChanges() {
        return this.toManyRelationshipChanges != null ? this.toManyRelationshipChanges : Collections.emptyMap();
    }

    @Override
    public Map<String, ? extends ToOneRelationshipChange> getToOneRelationshipChanges() {
        return this.toOneRelationshipChanges != null ? this.toOneRelationshipChanges : Collections.emptyMap();
    }

    @Override
    public ObjectChangeType getType() {
        return this.type;
    }

    @Override
    public ObjectId getPreCommitId() {
        return this.preCommitId;
    }

    @Override
    public ObjectId getPostCommitId() {
        return this.postCommitId != null ? this.postCommitId : this.preCommitId;
    }

    public void setPostCommitId(ObjectId postCommitId) {
        this.postCommitId = postCommitId;
    }

    public void setType(ObjectChangeType changeType) {
        if (this.type == null || TYPE_PRECEDENCE[changeType.ordinal()] > TYPE_PRECEDENCE[this.type.ordinal()]) {
            this.type = changeType;
        }
    }

    public void toManyRelationshipConnected(String property, ObjectId value) {
        this.getOrCreateToManyChange(property).connected(value);
    }

    public void toManyRelationshipDisconnected(String property, ObjectId value) {
        this.getOrCreateToManyChange(property).disconnected(value);
    }

    public void toOneRelationshipConnected(String property, ObjectId value) {
        this.getOrCreateToOneChange(property).connected(value);
    }

    public void toOneRelationshipDisconnected(String property, ObjectId value) {
        this.getOrCreateToOneChange(property).disconnected(value);
    }

    public void attributeChanged(String property, Object oldValue, Object newValue) {
        if (this.type == null) {
            throw new IllegalStateException("Null op");
        }
        MutableAttributeChange c = this.getOrCreateAttributeChange(property);
        c.setNewValue(newValue);
        c.setOldValue(oldValue);
    }

    private MutableAttributeChange getOrCreateAttributeChange(String property) {
        MutableAttributeChange pChange;
        MutableAttributeChange mutableAttributeChange = pChange = this.attributeChanges != null ? this.attributeChanges.get(property) : null;
        if (pChange == null) {
            if (this.attributeChanges == null) {
                this.attributeChanges = new HashMap<String, MutableAttributeChange>();
            }
            pChange = new MutableAttributeChange();
            this.attributeChanges.put(property, pChange);
        }
        return pChange;
    }

    private MutableToOneRelationshipChange getOrCreateToOneChange(String property) {
        MutableToOneRelationshipChange pChange;
        MutableToOneRelationshipChange mutableToOneRelationshipChange = pChange = this.toOneRelationshipChanges != null ? this.toOneRelationshipChanges.get(property) : null;
        if (pChange == null) {
            if (this.toOneRelationshipChanges == null) {
                this.toOneRelationshipChanges = new HashMap<String, MutableToOneRelationshipChange>();
            }
            pChange = new MutableToOneRelationshipChange();
            this.toOneRelationshipChanges.put(property, pChange);
        }
        return pChange;
    }

    private MutableToManyRelationshipChange getOrCreateToManyChange(String property) {
        MutableToManyRelationshipChange pChange;
        MutableToManyRelationshipChange mutableToManyRelationshipChange = pChange = this.toManyRelationshipChanges != null ? this.toManyRelationshipChanges.get(property) : null;
        if (pChange == null) {
            if (this.toManyRelationshipChanges == null) {
                this.toManyRelationshipChanges = new HashMap<String, MutableToManyRelationshipChange>();
            }
            pChange = new MutableToManyRelationshipChange();
            this.toManyRelationshipChanges.put(property, pChange);
        }
        return pChange;
    }

    static {
        MutableObjectChange.TYPE_PRECEDENCE[ObjectChangeType.DELETE.ordinal()] = 3;
        MutableObjectChange.TYPE_PRECEDENCE[ObjectChangeType.INSERT.ordinal()] = 2;
        MutableObjectChange.TYPE_PRECEDENCE[ObjectChangeType.UPDATE.ordinal()] = 1;
    }
}

