/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.id;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.lifecycle.id.EntityIdCoder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ClassDescriptor;

public class StringIdQuery
implements Query {
    @Deprecated
    protected String name;
    @Deprecated
    protected DataMap dataMap;
    protected Collection<String> stringIds;
    protected transient Map<String, SelectQuery> idQueriesByEntity;

    private static Collection<String> toCollection(String ... stringIds) {
        if (stringIds == null) {
            throw new NullPointerException("Null stringIds");
        }
        return Arrays.asList(stringIds);
    }

    public StringIdQuery(String ... stringIds) {
        this(StringIdQuery.toCollection(stringIds));
    }

    public StringIdQuery(Collection<String> stringIds) {
        this.stringIds = new HashSet<String>(stringIds);
    }

    public Collection<String> getStringIds() {
        return this.stringIds;
    }

    public void addStringIds(String ... ids) {
        if (ids == null) {
            throw new NullPointerException("Null ids");
        }
        boolean changed = false;
        for (String id : ids) {
            if (!this.stringIds.add(id)) continue;
            changed = true;
        }
        if (changed) {
            this.idQueriesByEntity = null;
        }
    }

    protected Map<String, SelectQuery> getIdQueriesByEntity(EntityResolver resolver) {
        if (this.idQueriesByEntity == null) {
            HashMap<String, SelectQuery> idQueriesByEntity = new HashMap<String, SelectQuery>();
            HashMap<String, EntityIdCoder> codersByEntity = new HashMap<String, EntityIdCoder>();
            for (String id : this.stringIds) {
                SelectQuery query;
                String entityName = EntityIdCoder.getEntityName(id);
                EntityIdCoder coder = (EntityIdCoder)codersByEntity.get(entityName);
                if (coder == null) {
                    coder = new EntityIdCoder(resolver.getObjEntity(entityName));
                    query = new SelectQuery(entityName);
                    codersByEntity.put(entityName, coder);
                    idQueriesByEntity.put(entityName, query);
                } else {
                    query = (SelectQuery)idQueriesByEntity.get(entityName);
                }
                Expression idExp = ExpressionFactory.matchAllDbExp((Map)coder.toObjectId(id).getIdSnapshot(), (int)3);
                query.orQualifier(idExp);
            }
            this.idQueriesByEntity = idQueriesByEntity;
        }
        return this.idQueriesByEntity;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        return new QueryMetadata(){

            public DataMap getDataMap() {
                return null;
            }

            public List<Object> getResultSetMapping() {
                return null;
            }

            public boolean isSingleResultSetMapping() {
                return false;
            }

            @Deprecated
            public Query getOrginatingQuery() {
                return null;
            }

            public Query getOriginatingQuery() {
                return null;
            }

            public QueryCacheStrategy getCacheStrategy() {
                return QueryCacheStrategy.getDefaultStrategy();
            }

            public DbEntity getDbEntity() {
                return null;
            }

            public ObjEntity getObjEntity() {
                return null;
            }

            public ClassDescriptor getClassDescriptor() {
                return null;
            }

            public Procedure getProcedure() {
                return null;
            }

            public String getCacheKey() {
                return null;
            }

            @Deprecated
            public String[] getCacheGroups() {
                return null;
            }

            public String getCacheGroup() {
                return null;
            }

            public boolean isFetchingDataRows() {
                return true;
            }

            public boolean isRefreshingObjects() {
                return true;
            }

            public int getPageSize() {
                return 0;
            }

            public int getFetchOffset() {
                return -1;
            }

            public int getFetchLimit() {
                return 0;
            }

            public PrefetchTreeNode getPrefetchTree() {
                return null;
            }

            public Map<String, String> getPathSplitAliases() {
                return Collections.emptyMap();
            }

            public int getStatementFetchSize() {
                return 0;
            }
        };
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        Map<String, SelectQuery> queries = this.getIdQueriesByEntity(resolver);
        for (SelectQuery query : queries.values()) {
            query.route(router, resolver, (Query)this);
        }
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new UnsupportedOperationException("This query was supposed to be replace with a set of SelectQueries during the route phase");
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public DataMap getDataMap() {
        return this.dataMap;
    }

    @Deprecated
    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }
}

