/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.postcommit;

import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.lifecycle.changemap.MutableChangeMap;
import org.apache.cayenne.lifecycle.changemap.MutableObjectChange;
import org.apache.cayenne.lifecycle.changemap.ObjectChangeType;
import org.apache.cayenne.lifecycle.postcommit.Confidential;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntity;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntityFactory;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DeletedDiffProcessor
implements GraphChangeHandler {
    private static final Log LOGGER = LogFactory.getLog(DeletedDiffProcessor.class);
    private PostCommitEntityFactory entityFactory;
    private MutableChangeMap changeSet;
    private DataChannel channel;

    DeletedDiffProcessor(MutableChangeMap changeSet, DataChannel channel, PostCommitEntityFactory entityFactory) {
        this.changeSet = changeSet;
        this.channel = channel;
        this.entityFactory = entityFactory;
    }

    public void nodeRemoved(Object nodeId) {
        ObjectId id = (ObjectId)nodeId;
        final MutableObjectChange objectChangeSet = this.changeSet.getOrCreate(id, ObjectChangeType.DELETE);
        ObjectIdQuery query = new ObjectIdQuery(id, true, 1);
        QueryResponse result = this.channel.onQuery(null, (Query)query);
        List rows = result.firstList();
        if (rows.isEmpty()) {
            LOGGER.warn((Object)("No DB snapshot for object to be deleted, no changes will be recorded. ID: " + id));
            return;
        }
        final DataRow row = (DataRow)rows.get(0);
        ClassDescriptor descriptor = this.channel.getEntityResolver().getClassDescriptor(id.getEntityName());
        final PostCommitEntity entity = this.entityFactory.getEntity(id);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                Object value;
                if (!entity.isIncluded(property.getName())) {
                    return true;
                }
                if (entity.isConfidential(property.getName())) {
                    value = Confidential.getInstance();
                } else {
                    String key = property.getAttribute().getDbAttributeName();
                    value = row.get((Object)key);
                }
                if (value != null) {
                    objectChangeSet.attributeChanged(property.getName(), value, null);
                }
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }
        });
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    public void nodeCreated(Object nodeId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
    }
}

