/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.postcommit;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.lifecycle.postcommit.Confidential;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntity;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntityFactory;

class DiffFilter
implements GraphChangeHandler {
    private PostCommitEntityFactory entityFactory;
    private GraphChangeHandler delegate;

    DiffFilter(PostCommitEntityFactory entityFactory, GraphChangeHandler delegate) {
        this.entityFactory = entityFactory;
        this.delegate = delegate;
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded()) {
            this.delegate.nodeIdChanged(nodeId, newId);
        }
    }

    public void nodeCreated(Object nodeId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded()) {
            this.delegate.nodeCreated(nodeId);
        }
    }

    public void nodeRemoved(Object nodeId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded()) {
            this.delegate.nodeRemoved(nodeId);
        }
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        PostCommitEntity entity = this.entityFactory.getEntity((ObjectId)nodeId);
        if (entity.isIncluded(property)) {
            if (entity.isConfidential(property)) {
                oldValue = Confidential.getInstance();
                newValue = Confidential.getInstance();
            }
            this.delegate.nodePropertyChanged(nodeId, property, oldValue, newValue);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded(arcId.toString())) {
            this.delegate.arcCreated(nodeId, targetNodeId, arcId);
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded(arcId.toString())) {
            this.delegate.arcDeleted(nodeId, targetNodeId, arcId);
        }
    }
}

