/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.postcommit;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.lifecycle.changemap.MutableChangeMap;
import org.apache.cayenne.lifecycle.changemap.MutableObjectChange;
import org.apache.cayenne.lifecycle.changemap.ObjectChangeType;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

class DiffProcessor
implements GraphChangeHandler {
    private EntityResolver entityResolver;
    private MutableChangeMap changeSet;

    DiffProcessor(MutableChangeMap changeSet, EntityResolver entityResolver) {
        this.changeSet = changeSet;
        this.entityResolver = entityResolver;
    }

    public void nodeRemoved(Object nodeId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.changeSet.getOrCreate((ObjectId)nodeId, ObjectChangeType.UPDATE).attributeChanged(property, oldValue, newValue);
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        this.changeSet.aliasId((ObjectId)nodeId, (ObjectId)newId);
    }

    public void nodeCreated(Object nodeId) {
        this.changeSet.getOrCreate((ObjectId)nodeId, ObjectChangeType.INSERT);
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjectId id = (ObjectId)nodeId;
        String relationshipName = arcId.toString();
        ObjEntity entity = this.entityResolver.getObjEntity(id.getEntityName());
        ObjRelationship relationship = entity.getRelationship(relationshipName);
        MutableObjectChange c = this.changeSet.getOrCreate(id, ObjectChangeType.UPDATE);
        ObjectId tid = (ObjectId)targetNodeId;
        if (relationship.isToMany()) {
            c.toManyRelationshipDisconnected(relationshipName, tid);
        } else {
            c.toOneRelationshipDisconnected(relationshipName, tid);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjectId id = (ObjectId)nodeId;
        String relationshipName = arcId.toString();
        ObjEntity entity = this.entityResolver.getObjEntity(id.getEntityName());
        ObjRelationship relationship = entity.getRelationship(relationshipName);
        MutableObjectChange c = this.changeSet.getOrCreate(id, ObjectChangeType.UPDATE);
        ObjectId tid = (ObjectId)targetNodeId;
        if (relationship.isToMany()) {
            c.toManyRelationshipConnected(relationshipName, tid);
        } else {
            c.toOneRelationshipConnected(relationshipName, tid);
        }
    }
}

