/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.postcommit;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.changemap.ChangeMap;
import org.apache.cayenne.lifecycle.changemap.MutableChangeMap;
import org.apache.cayenne.lifecycle.postcommit.DeletedDiffProcessor;
import org.apache.cayenne.lifecycle.postcommit.DiffFilter;
import org.apache.cayenne.lifecycle.postcommit.DiffProcessor;
import org.apache.cayenne.lifecycle.postcommit.PostCommitListener;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntityFactory;
import org.apache.cayenne.query.Query;

public class PostCommitFilter
implements DataChannelFilter {
    static final String POST_COMMIT_LISTENERS_LIST = "cayenne.server.post_commit.listeners";
    private PostCommitEntityFactory entityFactory;
    private Collection<PostCommitListener> listeners;

    public PostCommitFilter(@Inject PostCommitEntityFactory entityFactory, @Inject(value="cayenne.server.post_commit.listeners") List<PostCommitListener> listeners) {
        this.entityFactory = entityFactory;
        this.listeners = listeners;
    }

    public void init(DataChannel channel) {
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff beforeDiff, int syncType, DataChannelFilterChain filterChain) {
        if (syncType != 2 && syncType != 1) {
            return filterChain.onSync(originatingContext, beforeDiff, syncType);
        }
        if (this.listeners.isEmpty()) {
            return filterChain.onSync(originatingContext, beforeDiff, syncType);
        }
        MutableChangeMap changes = new MutableChangeMap();
        DataChannel channel = originatingContext.getChannel();
        this.beforeCommit(changes, channel, beforeDiff);
        GraphDiff afterDiff = filterChain.onSync(originatingContext, beforeDiff, syncType);
        this.afterCommit(changes, channel, beforeDiff, afterDiff);
        this.notifyListeners(originatingContext, changes);
        return afterDiff;
    }

    private void beforeCommit(MutableChangeMap changes, DataChannel channel, GraphDiff contextDiff) {
        DiffFilter handler = new DiffFilter(this.entityFactory, new DeletedDiffProcessor(changes, channel, this.entityFactory));
        contextDiff.apply((GraphChangeHandler)handler);
    }

    private void afterCommit(MutableChangeMap changes, DataChannel channel, GraphDiff contextDiff, GraphDiff dbDiff) {
        DiffFilter handler = new DiffFilter(this.entityFactory, new DiffProcessor(changes, channel.getEntityResolver()));
        contextDiff.apply((GraphChangeHandler)handler);
        dbDiff.apply((GraphChangeHandler)handler);
    }

    private void notifyListeners(ObjectContext originatingContext, ChangeMap changes) {
        for (PostCommitListener l : this.listeners) {
            l.onPostCommit(originatingContext, changes);
        }
    }
}

