/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.postcommit;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.lifecycle.postcommit.PostCommitFilter;
import org.apache.cayenne.lifecycle.postcommit.PostCommitListener;
import org.apache.cayenne.lifecycle.postcommit.meta.AuditablePostCommitEntityFactory;
import org.apache.cayenne.lifecycle.postcommit.meta.IncludeAllPostCommitEntityFactory;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntityFactory;
import org.apache.cayenne.tx.TransactionFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostCommitModuleBuilder {
    private static final Log LOGGER = LogFactory.getLog(PostCommitModuleBuilder.class);
    private Class<? extends PostCommitEntityFactory> entityFactoryType = IncludeAllPostCommitEntityFactory.class;
    private Collection<Class<? extends PostCommitListener>> listenerTypes = new HashSet<Class<? extends PostCommitListener>>();
    private Collection<PostCommitListener> listenerInstances = new HashSet<PostCommitListener>();
    private boolean excludeFromTransaction;

    public static PostCommitModuleBuilder builder() {
        return new PostCommitModuleBuilder();
    }

    PostCommitModuleBuilder() {
    }

    public PostCommitModuleBuilder listener(Class<? extends PostCommitListener> type) {
        this.listenerTypes.add(type);
        return this;
    }

    public PostCommitModuleBuilder listener(PostCommitListener instance) {
        this.listenerInstances.add(instance);
        return this;
    }

    public PostCommitModuleBuilder excludeFromTransaction() {
        this.excludeFromTransaction = true;
        return this;
    }

    public PostCommitModuleBuilder auditableEntitiesOnly() {
        this.entityFactoryType = AuditablePostCommitEntityFactory.class;
        return this;
    }

    public PostCommitModuleBuilder entityFactory(Class<? extends PostCommitEntityFactory> entityFactoryType) {
        this.entityFactoryType = entityFactoryType;
        return this;
    }

    public Module build() {
        return new Module(){

            public void configure(Binder binder) {
                if (PostCommitModuleBuilder.this.listenerTypes.isEmpty() && PostCommitModuleBuilder.this.listenerInstances.isEmpty()) {
                    LOGGER.info((Object)"No listeners configured. Skipping PostCommitFilter registration");
                    return;
                }
                binder.bind(PostCommitEntityFactory.class).to(PostCommitModuleBuilder.this.entityFactoryType);
                ListBuilder listeners = binder.bindList("cayenne.server.post_commit.listeners").addAll(PostCommitModuleBuilder.this.listenerInstances);
                for (Class type : PostCommitModuleBuilder.this.listenerTypes) {
                    binder.bind(type).to(type);
                    listeners.add(type);
                }
                binder.bind(PostCommitFilter.class).to(PostCommitFilter.class);
                if (PostCommitModuleBuilder.this.excludeFromTransaction) {
                    ServerModule.contributeDomainFilters((Binder)binder).add(PostCommitFilter.class).after(TransactionFilter.class);
                } else {
                    ServerModule.contributeDomainFilters((Binder)binder).add(PostCommitFilter.class).before(TransactionFilter.class);
                }
            }
        };
    }
}

