/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.postcommit.meta;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.lifecycle.audit.Auditable;
import org.apache.cayenne.lifecycle.postcommit.meta.MutablePostCommitEntity;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntity;
import org.apache.cayenne.lifecycle.postcommit.meta.PostCommitEntityFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

public class AuditablePostCommitEntityFactory
implements PostCommitEntityFactory {
    private static final PostCommitEntity BLOCKED_ENTITY = new PostCommitEntity(){

        @Override
        public boolean isIncluded(String property) {
            return false;
        }

        @Override
        public boolean isConfidential(String property) {
            return false;
        }

        @Override
        public boolean isIncluded() {
            return false;
        }
    };
    private Provider<DataChannel> channelProvider;
    private ConcurrentMap<String, PostCommitEntity> entities = new ConcurrentHashMap<String, PostCommitEntity>();

    public AuditablePostCommitEntityFactory(@Inject Provider<DataChannel> channelProvider) {
        this.channelProvider = channelProvider;
    }

    @Override
    public PostCommitEntity getEntity(ObjectId id) {
        String entityName = id.getEntityName();
        PostCommitEntity descriptor = (PostCommitEntity)this.entities.get(entityName);
        if (descriptor == null) {
            PostCommitEntity newDescriptor = this.createDescriptor(entityName);
            PostCommitEntity existingDescriptor = this.entities.putIfAbsent(entityName, newDescriptor);
            descriptor = existingDescriptor != null ? existingDescriptor : newDescriptor;
        }
        return descriptor;
    }

    private EntityResolver getEntityResolver() {
        return ((DataChannel)this.channelProvider.get()).getEntityResolver();
    }

    private PostCommitEntity createDescriptor(String entityName) {
        EntityResolver entityResolver = this.getEntityResolver();
        ClassDescriptor classDescriptor = entityResolver.getClassDescriptor(entityName);
        Auditable a = classDescriptor.getObjectClass().getAnnotation(Auditable.class);
        if (a == null) {
            return BLOCKED_ENTITY;
        }
        ObjEntity entity = entityResolver.getObjEntity(entityName);
        return new MutablePostCommitEntity(entity).setConfidential(a.confidential()).setIgnoreProperties(a.ignoredProperties()).setIgnoreAttributes(a.ignoreAttributes()).setIgnoreToOneRelationships(a.ignoreToOneRelationships()).setIgnoreToManyRelationships(a.ignoreToManyRelationships());
    }
}

