/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.server.ServerCase;

public abstract class CayenneDOTestBase
extends ServerCase {
    public static final String artistName = "artist with one painting";
    public static final String galleryName = "my gallery";
    public static final String textReview = "this painting sucks...";
    public static final String paintingName = "painting about nothing";
    static final byte[] paintingImage = new byte[]{2, 3, 4, 5};
    @Inject
    protected ObjectContext context;

    protected Artist newArtist() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName(artistName);
        return a1;
    }

    protected Painting newPainting() {
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle(paintingName);
        return p1;
    }

    protected PaintingInfo newPaintingInfo() {
        PaintingInfo p1 = this.context.newObject(PaintingInfo.class);
        p1.setTextReview(textReview);
        p1.setImageBlob(paintingImage);
        return p1;
    }

    protected Painting fetchPainting() {
        SelectQuery q = new SelectQuery("Painting", ExpressionFactory.matchExp("paintingTitle", paintingName));
        List pts = this.context.performQuery(q);
        return pts.size() > 0 ? (Painting)pts.get(0) : null;
    }

    protected PaintingInfo fetchPaintingInfo() {
        SelectQuery<PaintingInfo> q = new SelectQuery<PaintingInfo>(PaintingInfo.class, ExpressionFactory.likeExp("textReview", textReview));
        List pts = this.context.performQuery(q);
        return pts.size() > 0 ? (PaintingInfo)pts.get(0) : null;
    }
}

