/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SQLSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.oneway.OnewayTable1;
import org.apache.cayenne.testdo.oneway.OnewayTable2;
import org.apache.cayenne.testdo.oneway.OnewayTable3;
import org.apache.cayenne.testdo.oneway.OnewayTable4;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-oneway-rels.xml")
public class OneWayRelationshipsIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper t1Helper;
    private TableHelper t2Helper;
    private TableHelper t3Helper;
    private TableHelper t4Helper;

    @Before
    public void setUp() throws Exception {
        this.t1Helper = new TableHelper(this.dbHelper, "oneway_table1");
        this.t1Helper.setColumns(new String[]{"ID"});
        this.t2Helper = new TableHelper(this.dbHelper, "oneway_table2");
        this.t2Helper.setColumns(new String[]{"ID", "TABLE1_ID"});
        this.t3Helper = new TableHelper(this.dbHelper, "oneway_table3");
        this.t3Helper.setColumns(new String[]{"ID"});
        this.t4Helper = new TableHelper(this.dbHelper, "oneway_table4");
        this.t4Helper.setColumns(new String[]{"ID", "TABLE3_ID"}).setColumnTypes(new int[]{4, 4});
    }

    @Test
    public void testToOne_TwoNew() throws SQLException {
        OnewayTable1 t1 = this.context.newObject(OnewayTable1.class);
        OnewayTable2 t2 = this.context.newObject(OnewayTable2.class);
        t2.setToOneOneWayDb(t1);
        this.context.commitChanges();
        int t1Pk = this.t1Helper.getInt("ID");
        Assert.assertEquals((long)Cayenne.intPKForObject(t1), (long)t1Pk);
        int t2FK = this.t2Helper.getInt("TABLE1_ID");
        Assert.assertEquals((long)t1Pk, (long)t2FK);
    }

    @Test
    public void testToOne_Replace() throws SQLException {
        this.t1Helper.insert(new Object[]{1}).insert(new Object[]{2});
        this.t2Helper.insert(new Object[]{1, 1});
        OnewayTable1 t11 = Cayenne.objectForPK(this.context, OnewayTable1.class, 1);
        OnewayTable1 t12 = Cayenne.objectForPK(this.context, OnewayTable1.class, 2);
        OnewayTable2 t2 = Cayenne.objectForPK(this.context, OnewayTable2.class, 1);
        Assert.assertSame((Object)t11, (Object)t2.getToOneOneWayDb());
        t2.setToOneOneWayDb(t12);
        this.context.commitChanges();
        Assert.assertSame((Object)t12, (Object)t2.getToOneOneWayDb());
        int t2FK = this.t2Helper.getInt("TABLE1_ID");
        Assert.assertEquals((long)2L, (long)t2FK);
    }

    @Test
    public void testToOne_ReplaceWithNull() throws SQLException {
        this.t1Helper.insert(new Object[]{1});
        this.t2Helper.insert(new Object[]{1, 1});
        OnewayTable1 t11 = Cayenne.objectForPK(this.context, OnewayTable1.class, 1);
        OnewayTable2 t2 = Cayenne.objectForPK(this.context, OnewayTable2.class, 1);
        Assert.assertSame((Object)t11, (Object)t2.getToOneOneWayDb());
        t2.setToOneOneWayDb(null);
        this.context.commitChanges();
        Assert.assertNull((Object)t2.getToOneOneWayDb());
        Object t2FK = this.t2Helper.getObject("TABLE1_ID");
        Assert.assertNull((Object)t2FK);
    }

    @Test
    public void testToMany_TwoNew() throws SQLException {
        OnewayTable3 t3 = this.context.newObject(OnewayTable3.class);
        OnewayTable4 t4 = this.context.newObject(OnewayTable4.class);
        t3.addToToManyOneWayDb(t4);
        this.context.commitChanges();
        int t3Pk = this.t3Helper.getInt("ID");
        Assert.assertEquals((long)Cayenne.intPKForObject(t3), (long)t3Pk);
        int t4FK = this.t4Helper.getInt("TABLE3_ID");
        Assert.assertEquals((long)t3Pk, (long)t4FK);
    }

    @Test
    public void testToMany_AddNew() throws SQLException {
        this.t3Helper.insert(new Object[]{1});
        this.t4Helper.insert(new Object[]{1, 1});
        OnewayTable3 t3 = Cayenne.objectForPK(this.context, OnewayTable3.class, 1);
        Assert.assertEquals((long)1L, (long)t3.getToManyOneWayDb().size());
        OnewayTable4 t41 = Cayenne.objectForPK(this.context, OnewayTable4.class, 1);
        Assert.assertTrue((boolean)t3.getToManyOneWayDb().contains(t41));
        OnewayTable4 t42 = this.context.newObject(OnewayTable4.class);
        t3.addToToManyOneWayDb(t42);
        this.context.commitChanges();
        Assert.assertEquals((long)2L, (long)t3.getToManyOneWayDb().size());
        SQLSelect<Integer> fksQuery = SQLSelect.scalarQuery(Integer.class, "oneway-rels", "SELECT TABLE3_ID FROM oneway_table4");
        List<Integer> fks = this.context.select(fksQuery);
        Assert.assertEquals((long)2L, (long)fks.size());
        for (Integer fk : fks) {
            Assert.assertEquals((Object)1, (Object)fk);
        }
    }

    @Test
    public void testToMany_AddExisting() throws SQLException {
        this.t3Helper.insert(new Object[]{1});
        this.t4Helper.insert(new Object[]{1, 1}).insert(new Object[]{2, null});
        OnewayTable3 t3 = Cayenne.objectForPK(this.context, OnewayTable3.class, 1);
        Assert.assertEquals((long)1L, (long)t3.getToManyOneWayDb().size());
        OnewayTable4 t41 = Cayenne.objectForPK(this.context, OnewayTable4.class, 1);
        Assert.assertTrue((boolean)t3.getToManyOneWayDb().contains(t41));
        OnewayTable4 t42 = Cayenne.objectForPK(this.context, OnewayTable4.class, 2);
        t3.addToToManyOneWayDb(t42);
        this.context.commitChanges();
        Assert.assertEquals((long)2L, (long)t3.getToManyOneWayDb().size());
        SQLSelect<Integer> fksQuery = SQLSelect.scalarQuery(Integer.class, "oneway-rels", "SELECT TABLE3_ID FROM oneway_table4");
        List<Integer> fks = this.context.select(fksQuery);
        Assert.assertEquals((long)2L, (long)fks.size());
        for (Integer fk : fks) {
            Assert.assertEquals((Object)1, (Object)fk);
        }
    }

    @Test
    public void testToMany_RemoveExisting() throws SQLException {
        this.t3Helper.insert(new Object[]{1});
        this.t4Helper.insert(new Object[]{1, 1}).insert(new Object[]{2, 1});
        OnewayTable3 t3 = Cayenne.objectForPK(this.context, OnewayTable3.class, 1);
        Assert.assertEquals((long)2L, (long)t3.getToManyOneWayDb().size());
        OnewayTable4 t41 = Cayenne.objectForPK(this.context, OnewayTable4.class, 1);
        Assert.assertTrue((boolean)t3.getToManyOneWayDb().contains(t41));
        OnewayTable4 t42 = Cayenne.objectForPK(this.context, OnewayTable4.class, 2);
        Assert.assertTrue((boolean)t3.getToManyOneWayDb().contains(t42));
        t3.removeFromToManyOneWayDb(t42);
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)t3.getToManyOneWayDb().size());
        SQLSelect<Integer> fksQuery = SQLSelect.scalarQuery(Integer.class, "oneway-rels", "SELECT TABLE3_ID FROM oneway_table4");
        List<Integer> fks = this.context.select(fksQuery);
        Assert.assertEquals((long)2L, (long)fks.size());
        Assert.assertTrue((boolean)fks.contains(1));
        Assert.assertTrue((boolean)fks.contains(null));
    }
}

