/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.MockPersistentObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PersistentObjectIT
extends ServerCase {
    @Test
    public void testObjectContext() {
        ObjectContext context = (ObjectContext)Mockito.mock(ObjectContext.class);
        MockPersistentObject object = new MockPersistentObject();
        Assert.assertNull((Object)object.getObjectContext());
        object.setObjectContext(context);
        Assert.assertSame((Object)context, (Object)object.getObjectContext());
    }

    @Test
    public void testPersistenceState() {
        MockPersistentObject object = new MockPersistentObject();
        Assert.assertEquals((long)1L, (long)object.getPersistenceState());
        object.setPersistenceState(6);
        Assert.assertEquals((long)6L, (long)object.getPersistenceState());
    }

    @Test
    public void testObjectID() {
        ObjectId id = new ObjectId("test");
        MockPersistentObject object = new MockPersistentObject();
        Assert.assertNull((Object)object.getObjectId());
        object.setObjectId(id);
        Assert.assertSame((Object)id, (Object)object.getObjectId());
    }
}

