/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

public class TranslationCase {
    protected Object tstObject;
    protected String sqlExp;
    protected String rootEntity;

    public TranslationCase(String rootEntity, Object tstObject, String sqlExp) {
        this.tstObject = tstObject;
        this.rootEntity = rootEntity;
        this.sqlExp = this.trim("\\b\\w+\\.", sqlExp);
    }

    protected String trim(String pattern, String str) {
        return this.trim(pattern, str, "");
    }

    protected String trim(String pattern, String str, String subst) {
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        return matcher.find() ? matcher.replaceFirst(subst) : str;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append(this.tstObject);
        return buf.toString();
    }

    public void assertTranslatedWell(String translated) {
        if (this.sqlExp == null) {
            Assert.assertNull((Object)translated);
            return;
        }
        Assert.assertNotNull((Object)translated);
        String aliasSubstituted = this.trim("\\b\\w+\\.", translated);
        Assert.assertEquals((String)("Unexpected translation: " + translated + "...."), (String)this.sqlExp, (String)aliasSubstituted);
    }

    public String getRootEntity() {
        return this.rootEntity;
    }

    public String getSqlExp() {
        return this.sqlExp;
    }
}

