/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Date;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.SQLTemplateCustomizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataNodeQueriesIT
extends ServerCase {
    @Inject
    protected DataNode node;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected SQLTemplateCustomizer sqlTemplateCustomizer;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    protected void createFourArtists() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tArtist.insert(new Object[]{201, "artist4"});
        this.tArtist.insert(new Object[]{3001, "artist5"});
    }

    @Test
    public void testCreatePkSupportForMapEntities() throws Exception {
        DbEntity artistEnt = this.node.getEntityResolver().getDbEntity("ARTIST");
        Assert.assertNotNull((Object)this.node.getAdapter().getPkGenerator().generatePk(this.node, artistEnt.getPrimaryKeys().iterator().next()));
        DbEntity exhibitEnt = this.node.getEntityResolver().getDbEntity("EXHIBIT");
        Assert.assertNotNull((Object)this.node.getAdapter().getPkGenerator().generatePk(this.node, exhibitEnt.getPrimaryKeys().iterator().next()));
    }

    @Test
    public void testPerfomQueriesSQLTemplate() throws Exception {
        String template = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob 'DATE'))";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("id", 1L);
        bindings.put("name", "a1");
        bindings.put("dob", new Date(System.currentTimeMillis()));
        query.setParameters(bindings);
        MockOperationObserver observer = new MockOperationObserver();
        this.node.performQueries(Collections.singletonList(query), observer);
        Assert.assertNotNull((Object)observer.countsForQuery(query));
        Assert.assertEquals((long)1L, (long)observer.countsForQuery(query)[0]);
        Assert.assertEquals((long)1L, (long)this.tArtist.getRowCount());
        Assert.assertEquals((long)1L, (long)this.tArtist.getLong("ARTIST_ID"));
        Assert.assertEquals((Object)"a1", (Object)this.tArtist.getString("ARTIST_NAME").trim());
    }

    @Test
    public void testPerfomQueriesSelectingSQLTemplate1() throws Exception {
        this.createFourArtists();
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        this.node.performQueries(Collections.singletonList(query), observer);
        List data = observer.rowsForQuery(query);
        Assert.assertEquals((long)4L, (long)data.size());
        DataRow row = (DataRow)data.get(2);
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)201, row.get("ARTIST_ID"));
    }

    @Test
    public void testPerfomQueriesSelectingSQLTemplate2() throws Exception {
        this.createFourArtists();
        String template = "SELECT * FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        this.sqlTemplateCustomizer.updateSQLTemplate(query);
        MockOperationObserver observer = new MockOperationObserver();
        this.node.performQueries(Collections.singletonList(query), observer);
        List data = observer.rowsForQuery(query);
        Assert.assertEquals((long)4L, (long)data.size());
        DataRow row = (DataRow)data.get(2);
        Assert.assertEquals((long)3L, (long)row.size());
        Number id = (Number)row.get("ARTIST_ID");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((long)201L, (long)id.intValue());
    }

    @Test
    public void testPerfomQueriesSelectingSQLTemplateAlias() throws Exception {
        this.createFourArtists();
        String template = "SELECT #result('ARTIST_ID' 'int' 'A') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        this.node.performQueries(Collections.singletonList(query), observer);
        List data = observer.rowsForQuery(query);
        Assert.assertEquals((long)4L, (long)data.size());
        DataRow row = (DataRow)data.get(2);
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)201, row.get("A"));
    }

    @Test
    public void testRunMultiLineSQLTemplateUNIX() throws Exception {
        String templateString = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME)\nVALUES (1, 'A')";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.node.performQueries(Collections.singletonList(template), new MockOperationObserver());
    }

    @Test
    public void testRunMultiLineSQLTemplateWindows() throws Exception {
        String templateString = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME)\r\nVALUES (1, 'A')";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.node.performQueries(Collections.singletonList(template), new MockOperationObserver());
    }

    @Test
    public void testRunMultiLineSQLTemplateMac() throws Exception {
        String templateString = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME)\rVALUES (1, 'A')";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.node.performQueries(Collections.singletonList(template), new MockOperationObserver());
    }
}

