/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;

public class MockDataNode
extends DataNode {
    protected DataDomain domain;
    protected DataNode node;
    protected boolean replaceResults;
    protected Map results = new HashMap();
    protected int runCount;

    public static MockDataNode interceptNode(DataDomain domain, DataNode node) {
        MockDataNode mockNode = new MockDataNode(node);
        mockNode.domain = domain;
        domain.removeDataNode(node.getName());
        domain.addNode(mockNode);
        return mockNode;
    }

    public MockDataNode(DataNode node) {
        this.node = node;
    }

    public void stopInterceptNode() {
        if (this.domain == null) {
            throw new IllegalStateException("No domain set.");
        }
        this.domain.removeDataNode(this.getName());
        this.domain.addNode(this.node);
    }

    public void reset() {
        this.runCount = 0;
        this.results.clear();
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void addExpectedResult(Query query, List result) {
        this.replaceResults = true;
        this.results.put(query, result);
    }

    public void performQueries(Collection queries, OperationObserver resultConsumer) {
        this.runCount += queries.size();
        if (this.replaceResults) {
            this.initWithPresetResults(queries, resultConsumer);
        } else {
            this.node.performQueries(queries, resultConsumer);
        }
    }

    private void initWithPresetResults(Collection queries, OperationObserver resultConsumer) {
        for (Query query : queries) {
            resultConsumer.nextRows(query, (List)this.results.get(query));
        }
    }

    @Override
    public void addDataMap(DataMap map) {
        this.node.addDataMap(map);
    }

    public boolean equals(Object obj) {
        return this.node.equals(obj);
    }

    @Override
    public DbAdapter getAdapter() {
        return this.node.getAdapter();
    }

    public Collection getDataMaps() {
        return this.node.getDataMaps();
    }

    @Override
    public DataSource getDataSource() {
        return this.node.getDataSource();
    }

    @Override
    public String getDataSourceFactory() {
        return this.node.getDataSourceFactory();
    }

    @Override
    public String getDataSourceLocation() {
        return this.node.getDataSourceLocation();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.node.getEntityResolver();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public void removeDataMap(String mapName) {
        this.node.removeDataMap(mapName);
    }

    @Override
    public void setAdapter(DbAdapter adapter) {
        this.node.setAdapter(adapter);
    }

    public void setDataMaps(Collection dataMaps) {
        this.node.setDataMaps(dataMaps);
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.node.setDataSource(dataSource);
    }

    @Override
    public void setDataSourceFactory(String dataSourceFactory) {
        this.node.setDataSourceFactory(dataSourceFactory);
    }

    @Override
    public void setDataSourceLocation(String dataSourceLocation) {
        this.node.setDataSourceLocation(dataSourceLocation);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.node.setEntityResolver(entityResolver);
    }

    @Override
    public void setName(String name) {
        this.node.setName(name);
    }

    @Override
    public String toString() {
        return this.node.toString();
    }
}

