/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextLocalCacheIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    @Inject
    private DataContext context;

    @Test
    public void testLocalCacheStaysLocal() {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        ObjectContext child1 = this.runtime.newContext(this.context);
        Assert.assertNull((Object)((BaseContext)child1).getQueryCache().get(query.getMetaData(child1.getEntityResolver())));
        Assert.assertNull((Object)this.context.getQueryCache().get(query.getMetaData(this.context.getEntityResolver())));
        List results = child1.performQuery(query);
        Assert.assertSame((Object)results, (Object)((BaseContext)child1).getQueryCache().get(query.getMetaData(child1.getEntityResolver())));
        Assert.assertNull((Object)this.context.getQueryCache().get(query.getMetaData(this.context.getEntityResolver())));
    }
}

