/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextParentEventsIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    @Inject
    private DataContext context;

    @Test
    public void testParentUpdatedId() throws Exception {
        ObjectContext child1 = this.runtime.newContext(this.context);
        final Artist ac = child1.newObject(Artist.class);
        ac.setArtistName("X");
        child1.commitChangesToParent();
        final Artist ap = (Artist)this.context.getGraphManager().getNode(ac.getObjectId());
        Assert.assertNotNull((Object)ap);
        Assert.assertTrue((boolean)ap.getObjectId().isTemporary());
        this.context.commitChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertFalse((boolean)ap.getObjectId().isTemporary());
                Assert.assertEquals((Object)ap.getObjectId(), (Object)ac.getObjectId());
            }
        }.runTest(1000L);
    }
}

