/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextRollbackIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    @Inject
    private DataContext context;

    @Test
    public void testRollbackChanges() {
        ObjectContext child1 = this.runtime.newContext(this.context);
        Assert.assertFalse((boolean)this.context.hasChanges());
        Assert.assertFalse((boolean)child1.hasChanges());
        this.context.newObject(Artist.class);
        child1.newObject(Artist.class);
        Assert.assertTrue((boolean)this.context.hasChanges());
        Assert.assertTrue((boolean)child1.hasChanges());
        child1.rollbackChanges();
        Assert.assertFalse((boolean)this.context.hasChanges());
        Assert.assertFalse((boolean)child1.hasChanges());
    }

    @Test
    public void testRollbackChangesLocally() {
        ObjectContext child1 = this.runtime.newContext(this.context);
        Assert.assertFalse((boolean)this.context.hasChanges());
        Assert.assertFalse((boolean)child1.hasChanges());
        this.context.newObject(Artist.class);
        child1.newObject(Artist.class);
        Assert.assertTrue((boolean)this.context.hasChanges());
        Assert.assertTrue((boolean)child1.hasChanges());
        child1.rollbackChangesLocally();
        Assert.assertTrue((boolean)this.context.hasChanges());
        Assert.assertFalse((boolean)child1.hasChanges());
    }
}

