/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectStoreDiffRetainingIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"}).setColumnTypes(new int[]{-5, 1, 91});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"ARTIST_ID", "ESTIMATED_PRICE", "GALLERY_ID", "PAINTING_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{-5, 3, 4, 4, 12});
    }

    protected void createMixedDataSet() throws Exception {
        this.tArtist.insert(new Object[]{2000, "artist with one painting", null});
        this.tPainting.insert(new Object[]{2000, null, null, 3000, "p1"});
    }

    @Test
    public void testSnapshotRetainedOnPropertyModification() throws Exception {
        this.createMixedDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 2000);
        ObjectStore objectStore = this.context.getObjectStore();
        Assert.assertNull((Object)objectStore.getChangesByObjectId().get(a.getObjectId()));
        a.setArtistName("some other name");
        Assert.assertNotNull((Object)objectStore.getChangesByObjectId().get(a.getObjectId()));
    }

    @Test
    public void testSnapshotRetainedOnRelAndPropertyModification() throws Exception {
        this.createMixedDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 2000);
        ObjectStore objectStore = this.context.getObjectStore();
        Assert.assertNull((Object)objectStore.getChangesByObjectId().get(a.getObjectId()));
        a.addToPaintingArray(this.context.newObject(Painting.class));
        a.setArtistName("some other name");
        Assert.assertNotNull((String)"Snapshot wasn't retained - CAY-213", (Object)objectStore.getChangesByObjectId().get(a.getObjectId()));
    }
}

