/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

class SchemaAnalyzer {
    private Map<String, String> mapTableInDB = new HashMap<String, String>();
    private List<String> tableNoInDB = new ArrayList<String>();
    private Map<String, Collection<String>> nameSchemaMap = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> schemaNameMap = new HashMap<String, Collection<String>>();
    private Map<Map<String, String>, Collection<DbAttribute>> entityTables = new HashMap<Map<String, String>, Collection<DbAttribute>>();
    private String errorMessage = null;

    SchemaAnalyzer() {
    }

    public List<String> getTableNoInDB() {
        return this.tableNoInDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareColumns(DatabaseMetaData md) throws SQLException {
        for (Map.Entry<String, String> map : this.mapTableInDB.entrySet()) {
            String schema = map.getValue();
            String name = map.getKey();
            ResultSet rs = md.getColumns(null, schema, name, null);
            try {
                HashMap<String, String> schemaName = new HashMap<String, String>();
                schemaName.put(name, schema);
                Collection<DbAttribute> atribute = this.entityTables.get(schemaName);
                if (atribute == null) {
                    schemaName.remove(name);
                    schemaName.put(name, null);
                    atribute = this.entityTables.get(schemaName);
                }
                if (atribute == null || rs.getFetchSize() == 0) continue;
                int countColumn = 0;
                int isInEntity = 0;
                while (rs.next()) {
                    ++countColumn;
                    String columnName = rs.getString("COLUMN_NAME");
                    for (DbAttribute attr : atribute) {
                        if (!attr.getName().equalsIgnoreCase(columnName)) continue;
                        ++isInEntity;
                    }
                }
                if (countColumn != atribute.size()) {
                    this.errorMessage = "different number of columns in table " + name;
                    continue;
                }
                if (countColumn == isInEntity || this.errorMessage != null) continue;
                this.errorMessage = "no columns in table " + name + " or does not match the type of column";
            }
            finally {
                rs.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean compareTables(DatabaseMetaData md, Collection<DbEntity> entities) {
        boolean isIncluded = true;
        Iterator<DbEntity> i$ = entities.iterator();
        while (i$.hasNext()) {
            DbEntity ent = i$.next();
            String name = ent.getName();
            String schema = ent.getSchema();
            Collection<DbAttribute> atributes = ent.getAttributes();
            if (schema != null) {
                if (this.schemaNameMap.get(schema) == null) {
                    isIncluded = false;
                    this.errorMessage = "no schema " + schema + " in db";
                    return isIncluded;
                }
                Collection<String> names = this.schemaNameMap.get(schema);
                if (names.contains(name)) {
                    this.mapTableInDB.put(name, schema);
                } else {
                    this.tableNoInDB.add(name);
                }
            } else if (this.nameSchemaMap.get(name) != null || !ent.getDataMap().isQuotingSQLIdentifiers() && (this.nameSchemaMap.get(name.toLowerCase()) != null || this.nameSchemaMap.get(name.toUpperCase()) != null)) {
                Collection<String> sc = this.nameSchemaMap.get(name);
                if (sc == null) {
                    sc = this.nameSchemaMap.get(name.toLowerCase()) != null ? this.nameSchemaMap.get(name.toLowerCase()) : this.nameSchemaMap.get(name.toUpperCase());
                }
                if (sc.size() == 1) {
                    this.mapTableInDB.put(name, sc.iterator().next());
                } else {
                    this.errorMessage = " enter the schema. Table found in the schemas: ";
                    Iterator<String> it = sc.iterator();
                    String names = "";
                    while (it.hasNext()) {
                        names = names + it.next() + ", ";
                    }
                    this.errorMessage = this.errorMessage + names;
                }
            } else {
                this.tableNoInDB.add(name);
            }
            HashMap<String, String> schemaName = new HashMap<String, String>();
            schemaName.put(name, schema);
            this.entityTables.put(schemaName, atributes);
        }
        return isIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeSchemas(List<String> schemas, DatabaseMetaData md) throws SQLException {
        if (schemas.size() == 0) {
            schemas.add("%");
        }
        for (String schema : schemas) {
            ResultSet tables = md.getTables(null, schema, null, null);
            ArrayList<String> tableInSchema = new ArrayList<String>();
            try {
                while (tables.next()) {
                    Collection<Object> sc;
                    String name = tables.getString("TABLE_NAME");
                    if (name == null || name.startsWith("BIN$")) continue;
                    tableInSchema.add(name);
                    if (this.nameSchemaMap.get(name) != null) {
                        sc = this.nameSchemaMap.get(name);
                        Iterator<Object> iSc = sc.iterator();
                        boolean inSchema = false;
                        while (iSc.hasNext()) {
                            if (!((String)iSc.next()).equals(schema)) continue;
                            inSchema = true;
                        }
                        if (inSchema) continue;
                        sc.add(schema);
                        this.nameSchemaMap.remove(name);
                        this.nameSchemaMap.put(name, sc);
                        continue;
                    }
                    sc = new ArrayList<String>();
                    sc.add(schema);
                    this.nameSchemaMap.put(name, sc);
                }
                this.schemaNameMap.put(schema, tableInSchema);
            }
            finally {
                tables.close();
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

