/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.testdo.generated.GeneratedColumnTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-generated.xml")
public class BatchActionGeneratedIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testHasGeneratedKeys1() throws Exception {
        EntityResolver resolver = this.runtime.getChannel().getEntityResolver();
        JdbcAdapter adapter = this.buildAdapter(true);
        InsertBatchQuery batch1 = new InsertBatchQuery(resolver.getObjEntity(GeneratedColumnTestEntity.class).getDbEntity(), 5);
        DataNode node = new DataNode();
        node.setAdapter(adapter);
        node.setEntityResolver(resolver);
        node.setRowReaderFactory((RowReaderFactory)Mockito.mock(RowReaderFactory.class));
        Assert.assertTrue((boolean)new BatchAction(batch1, node, false).hasGeneratedKeys());
    }

    @Test
    public void testHasGeneratedKeys2() throws Exception {
        EntityResolver resolver = this.runtime.getChannel().getEntityResolver();
        JdbcAdapter adapter = this.buildAdapter(false);
        InsertBatchQuery batch1 = new InsertBatchQuery(resolver.getObjEntity(GeneratedColumnTestEntity.class).getDbEntity(), 5);
        DataNode node = new DataNode();
        node.setAdapter(adapter);
        node.setEntityResolver(resolver);
        node.setRowReaderFactory((RowReaderFactory)Mockito.mock(RowReaderFactory.class));
        Assert.assertFalse((boolean)new BatchAction(batch1, node, false).hasGeneratedKeys());
    }

    JdbcAdapter buildAdapter(boolean supportGeneratedKeys) {
        JdbcAdapter adapter = (JdbcAdapter)this.objectFactory.newInstance(JdbcAdapter.class, JdbcAdapter.class.getName());
        adapter.setSupportsGeneratedKeys(supportGeneratedKeys);
        return adapter;
    }
}

