/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class ColumnDescriptorTest {
    @Test
    public void testName() {
        ColumnDescriptor column = new ColumnDescriptor();
        column.setName("abc");
        Assert.assertEquals((Object)"abc", (Object)column.getName());
    }

    @Test
    public void testLabel() {
        ColumnDescriptor column = new ColumnDescriptor();
        column.setDataRowKey("abc");
        Assert.assertEquals((Object)"abc", (Object)column.getDataRowKey());
    }

    @Test
    public void testDbAttributeConstructor() {
        DbEntity entity = new DbEntity("entity");
        DbAttribute a = new DbAttribute();
        a.setName("name");
        a.setType(12);
        a.setEntity(entity);
        entity.addAttribute(a);
        ColumnDescriptor column = new ColumnDescriptor(a, null);
        Assert.assertEquals((Object)"name", (Object)column.getName());
        Assert.assertEquals((Object)"name", (Object)column.getQualifiedColumnName());
        Assert.assertEquals((Object)"entity", (Object)column.getTableName());
        Assert.assertEquals((Object)String.class.getName(), (Object)column.getJavaClass());
        Assert.assertEquals((Object)"name", (Object)column.getDataRowKey());
        Assert.assertEquals((long)12L, (long)column.getJdbcType());
    }

    @Test
    public void testEquals() {
        ColumnDescriptor column1 = new ColumnDescriptor();
        column1.setName("n1");
        column1.namePrefix = "np1";
        column1.setTableName("t1");
        column1.setJdbcType(12);
        ColumnDescriptor column2 = new ColumnDescriptor();
        column2.setName("n1");
        column2.namePrefix = "np1";
        column2.setTableName("t1");
        column2.setJdbcType(16);
        ColumnDescriptor column3 = new ColumnDescriptor();
        column3.setName("n1");
        column3.namePrefix = "np3";
        column3.setTableName("t1");
        Assert.assertEquals((Object)column1, (Object)column2);
        Assert.assertFalse((boolean)column1.equals(column3));
        Assert.assertFalse((boolean)column3.equals(column2));
    }

    @Test
    public void testHashCode() {
        ColumnDescriptor column1 = new ColumnDescriptor();
        column1.setName("n1");
        column1.namePrefix = "np1";
        column1.setTableName("t1");
        column1.setJdbcType(12);
        ColumnDescriptor column2 = new ColumnDescriptor();
        column2.setName("n1");
        column2.namePrefix = "np1";
        column2.setTableName("t1");
        column2.setJdbcType(16);
        ColumnDescriptor column3 = new ColumnDescriptor();
        column3.setName("n1");
        column3.namePrefix = "np3";
        column3.setTableName("t1");
        Assert.assertEquals((long)column1.hashCode(), (long)column2.hashCode());
        Assert.assertTrue((column1.hashCode() != column3.hashCode() ? 1 : 0) != 0);
    }
}

