/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.reader.DefaultRowReaderFactory;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.MockQueryMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JDBCResultIteratorTest {
    @Test
    public void testNextDataRow() throws Exception {
        MockConnection c = new MockConnection();
        MockStatement s = new MockStatement((Connection)c);
        MockResultSet rs = new MockResultSet("rs");
        rs.addColumn("a", new Object[]{"1", "2", "3"});
        RowDescriptor descriptor = new RowDescriptorBuilder().setResultSet((ResultSet)rs).getDescriptor(new ExtendedTypeMap());
        RowReader<?> rowReader = new DefaultRowReaderFactory().rowReader(descriptor, new MockQueryMetadata(), (DbAdapter)Mockito.mock(DbAdapter.class), Collections.<ObjAttribute, ColumnDescriptor>emptyMap());
        JDBCResultIterator it = new JDBCResultIterator((Statement)s, (ResultSet)rs, rowReader);
        DataRow row = (DataRow)it.nextRow();
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)1L, (long)row.size());
        Assert.assertEquals((Object)"1", row.get("a"));
    }

    @Test
    public void testClose() throws Exception {
        MockConnection c = new MockConnection();
        MockStatement s = new MockStatement((Connection)c);
        MockResultSet rs = new MockResultSet("rs");
        rs.addColumn("a", new Object[]{"1", "2", "3"});
        RowReader rowReader = (RowReader)Mockito.mock(RowReader.class);
        JDBCResultIterator it = new JDBCResultIterator((Statement)s, (ResultSet)rs, rowReader);
        Assert.assertFalse((boolean)rs.isClosed());
        Assert.assertFalse((boolean)s.isClosed());
        Assert.assertFalse((boolean)c.isClosed());
        it.close();
        Assert.assertTrue((boolean)rs.isClosed());
        Assert.assertTrue((boolean)s.isClosed());
    }
}

