/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ConnectionAwareResultIterator;
import org.apache.cayenne.access.jdbc.DistinctResultIterator;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.LimitResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;

public class SelectAction
extends BaseSQLAction {
    protected SelectQuery<?> query;

    public SelectAction(SelectQuery<?> query, DataNode dataNode) {
        super(dataNode);
        this.query = query;
    }

    protected SelectTranslator createTranslator(Connection connection) {
        return new SelectTranslator(this.query, this.dataNode, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        List<Object> resultRows;
        int offset;
        ResultSet rs;
        final long t1 = System.currentTimeMillis();
        SelectTranslator translator = this.createTranslator(connection);
        PreparedStatement prepStmt = translator.createStatement();
        final String sqlString = translator.createSqlString();
        try {
            rs = prepStmt.executeQuery();
        }
        catch (Exception ex) {
            prepStmt.close();
            throw ex;
        }
        QueryMetadata md = this.query.getMetaData(this.dataNode.getEntityResolver());
        RowDescriptor descriptor = new RowDescriptorBuilder().setColumns(translator.getResultColumns()).getDescriptor(this.dataNode.getAdapter().getExtendedTypes());
        RowReader<?> rowReader = this.dataNode.rowReader(descriptor, md, translator.getAttributeOverrides());
        JDBCResultIterator workerIterator = new JDBCResultIterator(prepStmt, rs, rowReader);
        ResultIterator<Object> it = workerIterator;
        if (observer.isIteratedResult()) {
            it = new ConnectionAwareResultIterator(it, connection){

                @Override
                protected void doClose() {
                    SelectAction.this.dataNode.getJdbcEventLogger().logSelectCount(this.rowCounter, System.currentTimeMillis() - t1, sqlString);
                    super.doClose();
                }
            };
        }
        if (translator.isSuppressingDistinct()) {
            final boolean[] compareFullRows = new boolean[1];
            final PrefetchTreeNode rootPrefetch = md.getPrefetchTree();
            if (rootPrefetch != null) {
                rootPrefetch.traverse(new PrefetchProcessor(){

                    @Override
                    public void finishPrefetch(PrefetchTreeNode node) {
                    }

                    @Override
                    public boolean startDisjointPrefetch(PrefetchTreeNode node) {
                        return rootPrefetch == node;
                    }

                    @Override
                    public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
                        return rootPrefetch == node;
                    }

                    @Override
                    public boolean startUnknownPrefetch(PrefetchTreeNode node) {
                        return rootPrefetch == node;
                    }

                    @Override
                    public boolean startJointPrefetch(PrefetchTreeNode node) {
                        if (rootPrefetch != node) {
                            compareFullRows[0] = true;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public boolean startPhantomPrefetch(PrefetchTreeNode node) {
                        return true;
                    }
                });
            }
            it = new DistinctResultIterator(workerIterator, translator.getRootDbEntity(), compareFullRows[0]);
        }
        int fetchLimit = this.query.getFetchLimit();
        int n = offset = translator.isSuppressingDistinct() ? this.query.getFetchOffset() : this.getInMemoryOffset(this.query.getFetchOffset());
        if (fetchLimit > 0 || offset > 0) {
            it = new LimitResultIterator(it, offset, fetchLimit);
        }
        if (observer.isIteratedResult()) {
            try {
                observer.nextRows(translator.getQuery(), it);
            }
            catch (Exception ex) {
                it.close();
                throw ex;
            }
        }
        try {
            resultRows = it.allRows();
        }
        finally {
            it.close();
        }
        this.dataNode.getJdbcEventLogger().logSelectCount(resultRows.size(), System.currentTimeMillis() - t1, sqlString);
        observer.nextRows(this.query, resultRows);
    }
}

