/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.commons.logging.Log;

public class LoggingDbLoaderDelegate
extends DefaultDbLoaderDelegate {
    private final Log logger;

    public LoggingDbLoaderDelegate(Log logger) {
        this.logger = logger;
    }

    @Override
    public void dbEntityAdded(DbEntity entity) {
        this.logger.info((Object)("  Table: " + entity.getFullyQualifiedName()));
    }

    @Override
    public void dbEntityRemoved(DbEntity entity) {
        this.logger.info((Object)("  Table removed: " + entity.getFullyQualifiedName()));
    }

    @Override
    public boolean dbRelationship(DbEntity entity) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("    Relationships for " + entity.getFullyQualifiedName()));
        }
        return true;
    }

    @Override
    public boolean dbRelationshipLoaded(DbEntity entity, DbRelationship relationship) {
        this.logger.info((Object)("    " + relationship));
        return true;
    }

    @Override
    public void objEntityAdded(ObjEntity entity) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  Class: " + entity.getName()));
        }
    }

    @Override
    public void objEntityRemoved(ObjEntity entity) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("  Class removed: " + entity.getName()));
        }
    }
}

