/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.regex.Pattern;
import org.apache.cayenne.access.loader.filters.Filter;
import org.apache.cayenne.access.loader.filters.ListFilter;

public class IncludeFilter
implements Filter<String> {
    private final Pattern pattern;

    IncludeFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean isInclude(String obj) {
        return this.pattern.matcher(obj).matches();
    }

    @Override
    public Filter join(Filter filter) {
        return ListFilter.create(this, filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ListFilter) {
            return o.equals(this);
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.pattern.toString().equals(((IncludeFilter)o).pattern.toString());
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return "+(" + this.pattern + ')';
    }

    protected Pattern getPattern() {
        return this.pattern;
    }
}

