/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.access.loader.filters.Filter;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.commons.lang.StringUtils;

public class ListFilter<T>
implements Filter<T> {
    private final Collection<Filter<T>> filters;

    public ListFilter(Collection<Filter<T>> filters) {
        this.filters = filters;
    }

    @Override
    public boolean isInclude(T obj) {
        for (Filter<T> filter : this.filters) {
            if (filter.isInclude(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Filter<T> join(Filter<T> filter) {
        LinkedList<Filter<T>> list = new LinkedList<Filter<T>>(this.filters);
        if (!FilterFactory.TRUE.equals(filter) && !FilterFactory.NULL.equals(filter)) {
            if (filter instanceof ListFilter) {
                list.addAll(((ListFilter)filter).filters);
            } else {
                list.add(filter);
            }
        }
        return new ListFilter<T>(list);
    }

    public static <T> Filter<T> create(Filter<T> filter1, Filter<T> filter2) {
        if (filter1 == null || FilterFactory.TRUE.equals(filter1) || FilterFactory.NULL.equals(filter1)) {
            return filter2;
        }
        if (filter2 == null || FilterFactory.TRUE.equals(filter2) || FilterFactory.NULL.equals(filter2)) {
            return filter1;
        }
        if (filter1 instanceof ListFilter) {
            return filter1.join(filter2);
        }
        if (filter2 instanceof ListFilter) {
            return filter2.join(filter1);
        }
        if (filter1.equals(filter2)) {
            return filter1;
        }
        return new ListFilter<T>(Arrays.asList(filter1, filter2));
    }

    public String toString() {
        return StringUtils.join(this.filters, (String)" & ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            if (o instanceof Filter && this.filters.size() == 1) {
                return o.equals(this.filters.iterator().next());
            }
            return false;
        }
        ListFilter that = (ListFilter)o;
        return this.filters != null ? this.filters.equals(that.filters) : that.filters == null;
    }

    public int hashCode() {
        return this.filters != null ? this.filters.hashCode() : 0;
    }
}

