/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DeleteBatchQuery;

public class DeleteBatchTranslator
extends DefaultBatchTranslator {
    public DeleteBatchTranslator(DeleteBatchQuery query, DbAdapter adapter, String trimFunction) {
        super(query, adapter, trimFunction);
    }

    @Override
    protected String createSql() {
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buffer = new StringBuilder("DELETE FROM ");
        buffer.append(strategy.quotedFullyQualifiedName(this.query.getDbEntity()));
        this.applyQualifier(buffer);
        return buffer.toString();
    }

    protected void applyQualifier(StringBuilder buffer) {
        buffer.append(" WHERE ");
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)this.query;
        Iterator<DbAttribute> i = deleteBatch.getDbAttributes().iterator();
        while (i.hasNext()) {
            DbAttribute attribute = i.next();
            this.appendDbAttribute(buffer, attribute);
            buffer.append(deleteBatch.isNull(attribute) ? " IS NULL" : " = ?");
            if (!i.hasNext()) continue;
            buffer.append(" AND ");
        }
    }

    @Override
    protected BatchParameterBinding[] createBindings() {
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)this.query;
        List<DbAttribute> attributes = deleteBatch.getDbAttributes();
        int len = attributes.size();
        BatchParameterBinding[] bindings = new BatchParameterBinding[len];
        for (int i = 0; i < len; ++i) {
            DbAttribute a = attributes.get(i);
            bindings[i] = new BatchParameterBinding(a);
        }
        return bindings;
    }

    @Override
    protected BatchParameterBinding[] doUpdateBindings(BatchQueryRow row) {
        int len = this.bindings.length;
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)this.query;
        int j = 1;
        for (int i = 0; i < len; ++i) {
            BatchParameterBinding b = this.bindings[i];
            if (deleteBatch.isNull(b.getAttribute())) {
                b.exclude();
                continue;
            }
            b.include(j++, row.getValue(i));
        }
        return this.bindings;
    }
}

