/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.PatternMatchNode;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.util.CayenneMapEntry;

public abstract class QueryAssemblerHelper {
    protected QueryAssembler queryAssembler;
    protected Appendable out;
    protected QuotingStrategy strategy;

    public QueryAssemblerHelper(QueryAssembler queryAssembler) {
        this.queryAssembler = queryAssembler;
        this.strategy = queryAssembler.getAdapter().getQuotingStrategy();
    }

    public ObjEntity getObjEntity() {
        return this.queryAssembler.getRootEntity();
    }

    public DbEntity getDbEntity() {
        return this.queryAssembler.getRootDbEntity();
    }

    public <T extends Appendable> T appendPart(T out) throws IOException {
        this.out = out;
        this.doAppendPart();
        return out;
    }

    void setOut(Appendable out) {
        this.out = out;
    }

    Appendable getOut() {
        return this.out;
    }

    protected abstract void doAppendPart() throws IOException;

    protected void appendLikeEscapeCharacter(PatternMatchNode patternMatchNode) throws IOException {
        char escapeChar = patternMatchNode.getEscapeChar();
        if ('?' == escapeChar) {
            throw new CayenneRuntimeException("the escape character of '?' is illegal for LIKE clauses.", new Object[0]);
        }
        if ('\u0000' != escapeChar) {
            this.out.append(" {escape '");
            this.out.append(escapeChar);
            this.out.append("'}");
        }
    }

    protected void appendObjPath(Expression pathExp) throws IOException {
        this.queryAssembler.resetJoinStack();
        String joinSplitAlias = null;
        for (PathComponent<ObjAttribute, ObjRelationship> component : this.getObjEntity().resolvePath(pathExp, this.queryAssembler.getPathAliases())) {
            if (component.isAlias()) {
                joinSplitAlias = component.getName();
                for (PathComponent<ObjAttribute, ObjRelationship> aliasPart : component.getAliasedPath()) {
                    ObjRelationship relationship = aliasPart.getRelationship();
                    if (relationship == null) {
                        throw new IllegalStateException("Non-relationship aliased path part: " + aliasPart.getName());
                    }
                    if (aliasPart.isLast() && component.isLast()) {
                        this.processRelTermination(relationship, aliasPart.getJoinType(), joinSplitAlias);
                        continue;
                    }
                    for (DbRelationship dbRel : relationship.getDbRelationships()) {
                        this.queryAssembler.dbRelationshipAdded(dbRel, aliasPart.getJoinType(), joinSplitAlias);
                    }
                }
                continue;
            }
            ObjRelationship relationship = component.getRelationship();
            ObjAttribute attribute = component.getAttribute();
            if (relationship != null) {
                if (component.isLast()) {
                    this.processRelTermination(relationship, component.getJoinType(), joinSplitAlias);
                    continue;
                }
                for (DbRelationship dbRel : relationship.getDbRelationships()) {
                    this.queryAssembler.dbRelationshipAdded(dbRel, component.getJoinType(), joinSplitAlias);
                }
                continue;
            }
            Iterator<CayenneMapEntry> dbPathIterator = attribute.getDbPathIterator();
            while (dbPathIterator.hasNext()) {
                CayenneMapEntry pathPart = dbPathIterator.next();
                if (pathPart == null) {
                    throw new CayenneRuntimeException("ObjAttribute has no component: " + attribute.getName(), new Object[0]);
                }
                if (pathPart instanceof DbRelationship) {
                    this.queryAssembler.dbRelationshipAdded((DbRelationship)pathPart, JoinType.INNER, joinSplitAlias);
                    continue;
                }
                if (!(pathPart instanceof DbAttribute)) continue;
                this.processColumnWithQuoteSqlIdentifiers((DbAttribute)pathPart, pathExp);
            }
        }
    }

    protected void appendDbPath(Expression pathExp) throws IOException {
        this.queryAssembler.resetJoinStack();
        String joinSplitAlias = null;
        for (PathComponent<DbAttribute, DbRelationship> component : this.getDbEntity().resolvePath(pathExp, this.queryAssembler.getPathAliases())) {
            if (component.isAlias()) {
                joinSplitAlias = component.getName();
                for (PathComponent<DbAttribute, DbRelationship> aliasPart : component.getAliasedPath()) {
                    DbRelationship relationship = aliasPart.getRelationship();
                    if (relationship == null) {
                        throw new IllegalStateException("Non-relationship aliased path part: " + aliasPart.getName());
                    }
                    if (aliasPart.isLast() && component.isLast()) {
                        this.processRelTermination(relationship, aliasPart.getJoinType(), joinSplitAlias);
                        continue;
                    }
                    this.queryAssembler.dbRelationshipAdded(relationship, component.getJoinType(), joinSplitAlias);
                }
                continue;
            }
            DbRelationship relationship = component.getRelationship();
            if (relationship != null) {
                if (component.isLast()) {
                    this.processRelTermination(relationship, component.getJoinType(), joinSplitAlias);
                    continue;
                }
                this.queryAssembler.dbRelationshipAdded(relationship, component.getJoinType(), joinSplitAlias);
                continue;
            }
            this.processColumnWithQuoteSqlIdentifiers(component.getAttribute(), pathExp);
        }
    }

    protected void processColumn(DbAttribute dbAttr) throws IOException {
        this.processColumnWithQuoteSqlIdentifiers(dbAttr, null);
    }

    protected void processColumnWithQuoteSqlIdentifiers(DbAttribute dbAttr, Expression pathExp) throws IOException {
        String alias = this.queryAssembler.supportsTableAliases() ? this.queryAssembler.getCurrentAlias() : null;
        this.out.append(this.strategy.quotedIdentifier(dbAttr.getEntity(), alias, dbAttr.getName()));
    }

    protected void appendLiteral(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        if (val == null) {
            this.out.append("NULL");
        } else if (val instanceof Persistent) {
            ObjectId id = ((Persistent)val).getObjectId();
            if (id == null) {
                throw new CayenneRuntimeException("Can't use TRANSIENT object as a query parameter.", new Object[0]);
            }
            if (id.isTemporary()) {
                throw new CayenneRuntimeException("Can't use NEW object as a query parameter.", new Object[0]);
            }
            Map<String, Object> snap = id.getIdSnapshot();
            if (snap.size() != 1) {
                StringBuilder msg = new StringBuilder();
                msg.append("Object must have a single primary key column ").append("to serve as a query parameter. ").append("This object has ").append(snap.size()).append(": ").append(snap);
                throw new CayenneRuntimeException(msg.toString(), new Object[0]);
            }
            this.appendLiteralDirect(snap.get(snap.keySet().iterator().next()), attr, parentExpression);
        } else if (val instanceof ObjectId) {
            ObjectId id = (ObjectId)val;
            if (id.isTemporary()) {
                throw new CayenneRuntimeException("Can't use NEW object as a query parameter.", new Object[0]);
            }
            Map<String, Object> snap = id.getIdSnapshot();
            if (snap.size() != 1) {
                StringBuilder msg = new StringBuilder();
                msg.append("Object must have a single primary key column ").append("to serve as a query parameter. ").append("This object has ").append(snap.size()).append(": ").append(snap);
                throw new CayenneRuntimeException(msg.toString(), new Object[0]);
            }
            this.appendLiteralDirect(snap.get(snap.keySet().iterator().next()), attr, parentExpression);
        } else {
            this.appendLiteralDirect(val, attr, parentExpression);
        }
    }

    protected void appendLiteralDirect(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        this.out.append('?');
        this.queryAssembler.addToParamList(attr, val);
    }

    protected DbAttribute paramsDbType(Expression e) {
        int len = e.getOperandCount();
        if (len < 2) {
            Expression parent;
            if (e instanceof SimpleNode && (parent = (Expression)((Object)((SimpleNode)e).jjtGetParent())) != null) {
                return this.paramsDbType(parent);
            }
            return null;
        }
        DbAttribute attribute = null;
        DbRelationship relationship = null;
        for (int i = 0; i < len; ++i) {
            PathComponent<Attribute, Relationship> last;
            Object op = e.getOperand(i);
            if (!(op instanceof Expression)) continue;
            Expression expression = (Expression)op;
            if (expression.getType() == 26) {
                List<DbRelationship> dbPath;
                last = this.getObjEntity().lastPathComponent(expression, this.queryAssembler.getPathAliases());
                if (last.getAttribute() != null) {
                    attribute = last.getAttribute().getDbAttribute();
                    break;
                }
                if (last.getRelationship() == null || (dbPath = ((ObjRelationship)last.getRelationship()).getDbRelationships()).size() <= 0) continue;
                relationship = dbPath.get(dbPath.size() - 1);
                break;
            }
            if (expression.getType() != 27) continue;
            last = this.getDbEntity().lastPathComponent(expression, this.queryAssembler.getPathAliases());
            if (last.getAttribute() != null) {
                attribute = (DbAttribute)last.getAttribute();
                break;
            }
            if (last.getRelationship() == null) continue;
            relationship = (DbRelationship)last.getRelationship();
            break;
        }
        if (attribute != null) {
            return attribute;
        }
        if (relationship != null && relationship.getJoins().size() == 1) {
            DbJoin join = relationship.getJoins().get(0);
            return join.getSource();
        }
        return null;
    }

    protected void processRelTermination(ObjRelationship rel, JoinType joinType, String joinSplitAlias) throws IOException {
        Iterator<DbRelationship> dbRels = rel.getDbRelationships().iterator();
        while (dbRels.hasNext()) {
            DbRelationship dbRel = dbRels.next();
            if (!dbRels.hasNext()) {
                this.processRelTermination(dbRel, joinType, joinSplitAlias);
                continue;
            }
            this.queryAssembler.dbRelationshipAdded(dbRel, joinType, joinSplitAlias);
        }
    }

    protected void processRelTermination(DbRelationship rel, JoinType joinType, String joinSplitAlias) throws IOException {
        List<DbJoin> joins;
        if (rel.isToMany()) {
            this.queryAssembler.dbRelationshipAdded(rel, joinType, joinSplitAlias);
        }
        if ((joins = rel.getJoins()).size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("OBJ_PATH expressions are only supported ").append("for a single-join relationships. ").append("This relationship has ").append(joins.size()).append(" joins.");
            throw new CayenneRuntimeException(msg.toString(), new Object[0]);
        }
        DbJoin join = joins.get(0);
        DbAttribute attribute = null;
        if (rel.isToMany()) {
            DbEntity ent = join.getRelationship().getTargetEntity();
            Collection<DbAttribute> pk = ent.getPrimaryKeys();
            if (pk.size() != 1) {
                StringBuilder msg = new StringBuilder();
                msg.append("DB_NAME expressions can only support ").append("targets with a single column PK. ").append("This entity has ").append(pk.size()).append(" columns in primary key.");
                throw new CayenneRuntimeException(msg.toString(), new Object[0]);
            }
            attribute = pk.iterator().next();
        } else {
            attribute = join.getSource();
        }
        this.processColumn(attribute);
    }
}

