/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.CompoundPainting;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SelectTranslatorIT
extends ServerCase {
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    private DataContext context;
    @Inject
    private UnitDbAdapter unitAdapter;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private JdbcEventLogger logger;
    @Inject
    private DataNode dataNode;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = this.dataSourceFactory.getSharedDataSource().getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
    }

    @Test
    public void testCreateSqlString1() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.likeExp("artistName", "a%"));
        q.addOrdering("dateOfBirth", SortOrder.ASCENDING);
        String generatedSql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" WHERE ") > generatedSql.indexOf(" FROM ") ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" ORDER BY ") > generatedSql.indexOf(" WHERE ") ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        entity.setQualifier(Expression.fromString("ARTIST_NAME = \"123\""));
        middleEntity.setQualifier(Expression.fromString("GROUP_ID = 1987"));
        try {
            String generatedSql = transl.createSqlString();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME = ") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier_OuterJoin() throws Exception {
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addOrdering("toArtist+.artistName", SortOrder.ASCENDING);
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        entity.setQualifier(Expression.fromString("ARTIST_NAME = \"123\""));
        middleEntity.setQualifier(Expression.fromString("GROUP_ID = 1987"));
        try {
            String generatedSql = transl.createSqlString();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME = ") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier_FlattenedRel() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("groupArray.name", "bar"));
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        entity.setQualifier(Expression.fromString("ARTIST_NAME = \"123\""));
        middleEntity.setQualifier(Expression.fromString("GROUP_ID = 1987"));
        try {
            String generatedSql = transl.createSqlString();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME = ") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier_RelatedMatch() throws Exception {
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, ExpressionFactory.matchExp("toArtist.artistName", "foo"));
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        entity.setQualifier(Expression.fromString("ARTIST_NAME = \"123\""));
        middleEntity.setQualifier(Expression.fromString("GROUP_ID = 1987"));
        try {
            String generatedSql = transl.createSqlString();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) = ") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME = ") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    @Test
    public void testCreateSqlString2() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.setDistinct(true);
        String generatedSql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT DISTINCT"));
    }

    @Test
    public void testCreateSqlString5() throws Exception {
        SelectQuery<ArtistExhibit> q = new SelectQuery<ArtistExhibit>(ArtistExhibit.class);
        q.setQualifier(ExpressionFactory.likeExp("toArtist.artistName", "a%"));
        q.andQualifier(ExpressionFactory.likeExp("toExhibit.toGallery.paintingArray.toArtist.artistName", "a%"));
        String generatedSql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" WHERE ") > generatedSql.indexOf(" FROM ") ? 1 : 0) != 0);
        int ind1 = generatedSql.indexOf("ARTIST t", generatedSql.indexOf(" FROM "));
        Assert.assertTrue((ind1 > 0 ? 1 : 0) != 0);
        int ind2 = generatedSql.indexOf("ARTIST t", ind1 + 1);
        Assert.assertTrue((ind2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.charAt(ind1 + "ARTIST t".length()) != generatedSql.charAt(ind2 + "ARTIST t".length()) ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString6() throws Exception {
        SelectQuery<ArtistExhibit> q = new SelectQuery<ArtistExhibit>(ArtistExhibit.class);
        q.setQualifier(ExpressionFactory.likeExp("toArtist.artistName", "a%"));
        q.andQualifier(ExpressionFactory.likeExp("toArtist.paintingArray.paintingTitle", "p%"));
        String generatedSql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" WHERE ") > generatedSql.indexOf(" FROM ") ? 1 : 0) != 0);
        int ind1 = generatedSql.indexOf("ARTIST t", generatedSql.indexOf(" FROM "));
        Assert.assertTrue((ind1 > 0 ? 1 : 0) != 0);
        int ind2 = generatedSql.indexOf("ARTIST t", ind1 + 1);
        Assert.assertTrue((String)generatedSql, (ind2 < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString7() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.setQualifier(ExpressionFactory.greaterExp("dateOfBirth", new Date()));
        q.andQualifier(ExpressionFactory.lessExp("dateOfBirth", new Date()));
        String generatedSql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        int i1 = generatedSql.indexOf(" FROM ");
        Assert.assertTrue((i1 > 0 ? 1 : 0) != 0);
        int i2 = generatedSql.indexOf(" WHERE ");
        Assert.assertTrue((i2 > i1 ? 1 : 0) != 0);
        int i3 = generatedSql.indexOf("DATE_OF_BIRTH", i2 + 1);
        Assert.assertTrue((i3 > i2 ? 1 : 0) != 0);
        int i4 = generatedSql.indexOf("DATE_OF_BIRTH", i3 + 1);
        Assert.assertTrue((String)("No second DOB comparison: " + i4 + ", " + i3), (i4 > i3 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString8() throws Exception {
        SelectQuery q = new SelectQuery();
        q.setRoot(Painting.class);
        q.setQualifier(ExpressionFactory.greaterExp("toArtist.dateOfBirth", new Date()));
        q.andQualifier(ExpressionFactory.lessExp("toArtist.dateOfBirth", new Date()));
        String generatedSql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        int i1 = generatedSql.indexOf(" FROM ");
        Assert.assertTrue((i1 > 0 ? 1 : 0) != 0);
        int i2 = generatedSql.indexOf(" WHERE ");
        Assert.assertTrue((i2 > i1 ? 1 : 0) != 0);
        int i3 = generatedSql.indexOf("DATE_OF_BIRTH", i2 + 1);
        Assert.assertTrue((i3 > i2 ? 1 : 0) != 0);
        int i4 = generatedSql.indexOf("DATE_OF_BIRTH", i3 + 1);
        Assert.assertTrue((String)("No second DOB comparison: " + i4 + ", " + i3), (i4 > i3 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString9() throws Exception {
        SelectQuery<CompoundPainting> q = new SelectQuery<CompoundPainting>(CompoundPainting.class, ExpressionFactory.likeExp("artistName", "a%"));
        String sql = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
        Assert.assertNotNull((Object)sql);
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        int i1 = sql.indexOf(" FROM ");
        Assert.assertTrue((i1 > 0 ? 1 : 0) != 0);
        int i2 = sql.indexOf("PAINTING");
        Assert.assertTrue((i2 > 0 ? 1 : 0) != 0);
        int i3 = sql.indexOf("ARTIST");
        Assert.assertTrue((i3 > 0 ? 1 : 0) != 0);
        int i4 = sql.indexOf("GALLERY");
        Assert.assertTrue((i4 > 0 ? 1 : 0) != 0);
        int i5 = sql.indexOf("PAINTING_INFO");
        Assert.assertTrue((i5 > 0 ? 1 : 0) != 0);
        int i6 = sql.indexOf("ARTIST_NAME");
        Assert.assertTrue((i6 > 0 ? 1 : 0) != 0);
        int i7 = sql.indexOf("ESTIMATED_PRICE");
        Assert.assertTrue((i7 > 0 ? 1 : 0) != 0);
        int i8 = sql.indexOf("GALLERY_NAME");
        Assert.assertTrue((i8 > 0 ? 1 : 0) != 0);
        int i9 = sql.indexOf("PAINTING_TITLE");
        Assert.assertTrue((i9 > 0 ? 1 : 0) != 0);
        int i10 = sql.indexOf("TEXT_REVIEW");
        Assert.assertTrue((i10 > 0 ? 1 : 0) != 0);
        int i11 = sql.indexOf("PAINTING_ID");
        Assert.assertTrue((i11 > 0 ? 1 : 0) != 0);
        int i12 = sql.indexOf("ARTIST_ID");
        Assert.assertTrue((i12 > 0 ? 1 : 0) != 0);
        int i13 = sql.indexOf("GALLERY_ID");
        Assert.assertTrue((i13 > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString10() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addPrefetch("paintingArray").setSemantics(1);
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        String sql = transl.createSqlString();
        Assert.assertNotNull((Object)sql);
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        int i1 = sql.indexOf("ARTIST_ID");
        Assert.assertTrue((String)sql, (i1 > 0 ? 1 : 0) != 0);
        int i2 = sql.indexOf("FROM");
        Assert.assertTrue((String)sql, (i2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("PAINTING_ID") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)transl.joinStack.size());
    }

    @Test
    public void testCreateSqlString11() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, Expression.fromString("paintingArray.paintingTitle = 'a'"));
        q.addPrefetch("paintingArray").setSemantics(1);
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        transl.createSqlString();
        Assert.assertEquals((long)2L, (long)transl.joinStack.size());
    }

    @Test
    public void testCreateSqlString12() throws Exception {
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch("toArtist").setSemantics(1);
        SelectTranslator transl = new SelectTranslator(q, this.dataNode, this.connection);
        String sql = transl.createSqlString();
        Assert.assertNotNull((Object)sql);
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        int i1 = sql.indexOf("ARTIST_ID");
        Assert.assertTrue((String)sql, (i1 > 0 ? 1 : 0) != 0);
        int i2 = sql.indexOf("FROM");
        Assert.assertTrue((String)sql, (i2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("PAINTING_ID") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)transl.joinStack.size());
    }

    @Test
    public void testCreateSqlString13() throws Exception {
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch("invalid.invalid").setSemantics(1);
        try {
            new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
            Assert.fail((String)"Invalid jointPrefetch must have thrown...");
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers() throws Exception {
        try {
            SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            q.addOrdering("dateOfBirth", SortOrder.ASCENDING);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
            Assert.assertTrue((boolean)s.startsWith("SELECT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((iFrom > 0 ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((iArtist > iFrom ? 1 : 0) != 0);
            int iOrderBy = s.indexOf(" ORDER BY ");
            int dateOfBirth2 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd, iOrderBy);
            Assert.assertTrue((iOrderBy > iArtist ? 1 : 0) != 0);
            Assert.assertTrue((dateOfBirth2 > iOrderBy ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers2() throws Exception {
        try {
            SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            q.setQualifier(ExpressionFactory.greaterExp("dateOfBirth", new Date()));
            q.andQualifier(ExpressionFactory.lessExp("dateOfBirth", new Date()));
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
            Assert.assertTrue((boolean)s.startsWith("SELECT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((iFrom > 0 ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((iArtist > iFrom ? 1 : 0) != 0);
            int iWhere = s.indexOf(" WHERE ");
            Assert.assertTrue((iWhere > iArtist ? 1 : 0) != 0);
            int dateOfBirth2 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd + " > ?");
            Assert.assertTrue((dateOfBirth2 > iWhere ? 1 : 0) != 0);
            int iAnd = s.indexOf(" AND ");
            Assert.assertTrue((iAnd > iWhere ? 1 : 0) != 0);
            int dateOfBirth3 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd + " < ?");
            Assert.assertTrue((dateOfBirth3 > iAnd ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers3() throws Exception {
        try {
            SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, Expression.fromString("paintingArray.paintingTitle = 'a'"));
            q.addPrefetch("paintingArray").setSemantics(1);
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
            Assert.assertTrue((boolean)s.startsWith("SELECT DISTINCT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((iFrom > 0 ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int estimatedPrice = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ESTIMATED_PRICE" + charEnd);
            Assert.assertTrue((estimatedPrice > 0 && estimatedPrice < iFrom ? 1 : 0) != 0);
            int paintingDescription = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "PAINTING_DESCRIPTION" + charEnd);
            Assert.assertTrue((paintingDescription > 0 && paintingDescription < iFrom ? 1 : 0) != 0);
            int paintingTitle = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "PAINTING_TITLE" + charEnd);
            Assert.assertTrue((paintingTitle > 0 && paintingTitle < iFrom ? 1 : 0) != 0);
            int artistIdT1 = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistIdT1 > 0 && artistIdT1 < iFrom ? 1 : 0) != 0);
            int galleryId = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "GALLERY_ID" + charEnd);
            Assert.assertTrue((galleryId > 0 && galleryId < iFrom ? 1 : 0) != 0);
            int paintingId = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "PAINTING_ID" + charEnd);
            Assert.assertTrue((paintingId > 0 && paintingId < iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((iArtist > iFrom ? 1 : 0) != 0);
            int iLeftJoin = s.indexOf("LEFT JOIN");
            Assert.assertTrue((iLeftJoin > iFrom ? 1 : 0) != 0);
            int iPainting = s.indexOf(charStart + "PAINTING" + charEnd + " " + charStart + "t1" + charEnd);
            Assert.assertTrue((iPainting > iLeftJoin ? 1 : 0) != 0);
            int iOn = s.indexOf(" ON ");
            Assert.assertTrue((iOn > iLeftJoin ? 1 : 0) != 0);
            int iArtistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((iArtistId > iOn ? 1 : 0) != 0);
            int iArtistIdT1 = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((iArtistIdT1 > iOn ? 1 : 0) != 0);
            int i = s.indexOf("=", iLeftJoin);
            Assert.assertTrue((iArtistIdT1 > i || iArtistId > i ? 1 : 0) != 0);
            int iJoin = s.indexOf("JOIN");
            Assert.assertTrue((iJoin > iLeftJoin ? 1 : 0) != 0);
            int iPainting2 = s.indexOf(charStart + "PAINTING" + charEnd + " " + charStart + "t2" + charEnd);
            Assert.assertTrue((iPainting2 > iJoin ? 1 : 0) != 0);
            int iOn2 = s.indexOf(" ON ");
            Assert.assertTrue((iOn2 > iJoin ? 1 : 0) != 0);
            int iArtistId2 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iJoin);
            Assert.assertTrue((iArtistId2 > iOn2 ? 1 : 0) != 0);
            int iArtistId2T2 = s.indexOf(charStart + "t2" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iJoin);
            Assert.assertTrue((iArtistId2T2 > iOn2 ? 1 : 0) != 0);
            int i2 = s.indexOf("=", iJoin);
            Assert.assertTrue((iArtistId2T2 > i2 || iArtistId2 > i2 ? 1 : 0) != 0);
            int iWhere = s.indexOf(" WHERE ");
            Assert.assertTrue((iWhere > iJoin ? 1 : 0) != 0);
            int paintingTitle2 = s.indexOf(charStart + "t2" + charEnd + "." + charStart + "PAINTING_TITLE" + charEnd + " = ?");
            Assert.assertTrue((paintingTitle2 > iWhere ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers4() throws Exception {
        try {
            SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
            q.addPrefetch("toArtist").setSemantics(1);
            DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new SelectTranslator(q, this.dataNode, this.connection).createSqlString();
            Assert.assertTrue((boolean)s.startsWith("SELECT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((iFrom > 0 ? 1 : 0) != 0);
            int paintingDescription = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "PAINTING_DESCRIPTION" + charEnd);
            Assert.assertTrue((paintingDescription > 0 && paintingDescription < iFrom ? 1 : 0) != 0);
            int paintingTitle = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "PAINTING_TITLE" + charEnd);
            Assert.assertTrue((paintingTitle > 0 && paintingTitle < iFrom ? 1 : 0) != 0);
            int artistIdT1 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistIdT1 > 0 && artistIdT1 < iFrom ? 1 : 0) != 0);
            int estimatedPrice = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ESTIMATED_PRICE" + charEnd);
            Assert.assertTrue((estimatedPrice > 0 && estimatedPrice < iFrom ? 1 : 0) != 0);
            int galleryId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "GALLERY_ID" + charEnd);
            Assert.assertTrue((galleryId > 0 && galleryId < iFrom ? 1 : 0) != 0);
            int paintingId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "PAINTING_ID" + charEnd);
            Assert.assertTrue((paintingId > 0 && paintingId < iFrom ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int iPainting = s.indexOf(charStart + "PAINTING" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((iPainting > iFrom ? 1 : 0) != 0);
            int iLeftJoin = s.indexOf("LEFT JOIN");
            Assert.assertTrue((iLeftJoin > iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t1" + charEnd);
            Assert.assertTrue((iArtist > iLeftJoin ? 1 : 0) != 0);
            int iOn = s.indexOf(" ON ");
            Assert.assertTrue((iOn > iLeftJoin ? 1 : 0) != 0);
            int iArtistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((iArtistId > iOn ? 1 : 0) != 0);
            int iArtistIdT1 = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((iArtistIdT1 > iOn ? 1 : 0) != 0);
            int i = s.indexOf("=", iLeftJoin);
            Assert.assertTrue((iArtistIdT1 > i || iArtistId > i ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    @Test
    public void testBuildResultColumns1() throws Exception {
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        SelectTranslator tr = new SelectTranslator(q, this.dataNode, this.connection);
        List<ColumnDescriptor> columns = tr.buildResultColumns();
        DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
        for (DbAttribute a : entity.getAttributes()) {
            ColumnDescriptor c = new ColumnDescriptor(a, "t0");
            Assert.assertTrue((String)("No descriptor for " + a + ", columns: " + columns), (boolean)columns.contains(c));
        }
    }

    @Test
    public void testBuildResultColumns2() throws Exception {
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addPrefetch("toArtist").setSemantics(1);
        SelectTranslator tr = new SelectTranslator(q, this.dataNode, this.connection);
        List<ColumnDescriptor> columns = tr.buildResultColumns();
        DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
        for (DbAttribute a : entity.getAttributes()) {
            ColumnDescriptor c = new ColumnDescriptor(a, "t0");
            Assert.assertTrue((String)("No descriptor for " + a + ", columns: " + columns), (boolean)columns.contains(c));
        }
        DbEntity joined = this.context.getEntityResolver().getDbEntity("ARTIST");
        for (DbAttribute a : joined.getAttributes()) {
            if ("ARTIST_ID".equals(a.getName())) continue;
            ColumnDescriptor c = new ColumnDescriptor(a, "t1");
            c.setDataRowKey("toArtist." + a.getName());
            Assert.assertTrue((String)("No descriptor for " + a + ", columns: " + columns), (boolean)columns.contains(c));
        }
    }
}

