/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.server;

import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianServlet;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.rop.server.ROPServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.web.WebConfiguration;
import org.apache.cayenne.configuration.web.WebUtil;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.hessian.HessianConfig;
import org.apache.cayenne.remote.hessian.service.HessianService;

public class ROPHessianServlet
extends HessianServlet {
    protected ServletContext servletContext;

    public void init(ServletConfig configuration) throws ServletException {
        this.checkAlreadyConfigured(configuration.getServletContext());
        this.servletContext = configuration.getServletContext();
        WebConfiguration configAdapter = new WebConfiguration(configuration);
        String configurationLocation = configAdapter.getConfigurationLocation();
        Map<String, String> eventBridgeParameters = configAdapter.getOtherParameters();
        Collection<Module> modules = configAdapter.createModules(new ROPServerModule(eventBridgeParameters));
        ServerRuntime runtime = new ServerRuntime(configurationLocation, modules.toArray(new Module[modules.size()]));
        DataChannel channel = runtime.getChannel();
        RemoteService service = (RemoteService)runtime.getInjector().getInstance(RemoteService.class);
        SerializerFactory serializerFactory = HessianConfig.createFactory(HessianService.SERVER_SERIALIZER_FACTORIES, channel.getEntityResolver());
        this.setAPIClass(RemoteService.class);
        this.setSerializerFactory(serializerFactory);
        this.setService(service);
        WebUtil.setCayenneRuntime(this.servletContext, runtime);
        super.init(configuration);
    }

    protected void checkAlreadyConfigured(ServletContext context) throws ServletException {
        if (WebUtil.getCayenneRuntime(context) != null) {
            throw new ServletException("CayenneRuntime is already configured in the servlet environment");
        }
    }

    public void destroy() {
        super.destroy();
        CayenneRuntime runtime = WebUtil.getCayenneRuntime(this.servletContext);
        if (runtime != null) {
            runtime.shutdown();
        }
    }
}

