/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.sql.DataSource;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;

public class DefaultDataNodeFactory
implements DataNodeFactory {
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    protected RowReaderFactory rowReaderFactory;
    @Inject
    protected DataSourceFactory dataSourceFactory;
    @Inject
    protected BatchTranslatorFactory batchTranslatorFactory;
    @Inject
    protected DbAdapterFactory adapterFactory;
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject
    protected SchemaUpdateStrategy defaultSchemaUpdateStrategy;
    @Inject
    protected SQLTemplateProcessor sqlTemplateProcessor;

    @Override
    public DataNode createDataNode(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataNode dataNode = new DataNode(nodeDescriptor.getName());
        dataNode.setJdbcEventLogger(this.jdbcEventLogger);
        dataNode.setRowReaderFactory(this.rowReaderFactory);
        dataNode.setBatchTranslatorFactory(this.batchTranslatorFactory);
        dataNode.setSqlTemplateProcessor(this.sqlTemplateProcessor);
        dataNode.setDataSourceLocation(nodeDescriptor.getParameters());
        DataSource dataSource = this.dataSourceFactory.getDataSource(nodeDescriptor);
        dataNode.setDataSourceFactory(nodeDescriptor.getDataSourceFactoryType());
        dataNode.setDataSource(dataSource);
        String schemaUpdateStrategyType = nodeDescriptor.getSchemaUpdateStrategyType();
        if (schemaUpdateStrategyType == null) {
            dataNode.setSchemaUpdateStrategy(this.defaultSchemaUpdateStrategy);
            dataNode.setSchemaUpdateStrategyName(this.defaultSchemaUpdateStrategy.getClass().getName());
        } else {
            SchemaUpdateStrategy strategy = (SchemaUpdateStrategy)this.objectFactory.newInstance(SchemaUpdateStrategy.class, schemaUpdateStrategyType);
            dataNode.setSchemaUpdateStrategyName(schemaUpdateStrategyType);
            dataNode.setSchemaUpdateStrategy(strategy);
        }
        dataNode.setAdapter(this.adapterFactory.createAdapter(nodeDescriptor, dataSource));
        return dataNode;
    }
}

