/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(JNDIDataSourceFactory.class);
    @Inject
    protected JdbcEventLogger jdbcEventLogger;

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        String location = this.getLocation(nodeDescriptor);
        try {
            return this.lookupViaJNDI(location);
        }
        catch (Exception ex) {
            logger.info((Object)("failed JNDI lookup of DataSource location '" + location + "'"));
            this.jdbcEventLogger.logConnectFailure(ex);
            throw ex;
        }
    }

    protected String getLocation(DataNodeDescriptor nodeDescriptor) {
        String location = nodeDescriptor.getParameters();
        if (location == null) {
            throw new CayenneRuntimeException("Null 'location' for nodeDescriptor '%s'", nodeDescriptor.getName());
        }
        return location;
    }

    DataSource lookupViaJNDI(String location) throws NamingException {
        DataSource dataSource;
        this.jdbcEventLogger.logConnect(location);
        InitialContext context = new InitialContext();
        try {
            Context envContext = (Context)context.lookup("java:comp/env");
            dataSource = (DataSource)envContext.lookup(location);
        }
        catch (NamingException namingEx) {
            dataSource = (DataSource)context.lookup(location);
        }
        this.jdbcEventLogger.logConnectSuccess();
        return dataSource;
    }
}

